/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.image.data;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.image.ImageItem;
import io.noties.markwon.image.ImageLoadedNotifier;
import io.noties.markwon.image.SchemeHandler;
import io.noties.markwon.image.data.DataUri;
import io.noties.markwon.image.data.DataUriDecoder;
import io.noties.markwon.image.data.DataUriParser;
import java.io.ByteArrayInputStream;
import java.util.Collection;
import java.util.Collections;

public class DataUriSchemeHandler
extends SchemeHandler {
    public static final String SCHEME = "data";
    private static final String START = "data:";
    private final DataUriParser uriParser;
    private final DataUriDecoder uriDecoder;

    public DataUriSchemeHandler() {
        this(DataUriParser.create(), DataUriDecoder.create(), false);
    }

    public DataUriSchemeHandler(boolean shouldHandleAsync) {
        this(DataUriParser.create(), DataUriDecoder.create(), shouldHandleAsync);
    }

    private DataUriSchemeHandler(@NonNull DataUriParser uriParser, @NonNull DataUriDecoder uriDecoder, boolean shouldHandleAsync) {
        this.uriParser = uriParser;
        this.uriDecoder = uriDecoder;
        this.shouldHandleAsync = shouldHandleAsync;
    }

    @Override
    @NonNull
    public ImageItem handle(@NonNull String raw, @NonNull Uri uri, @Nullable ImageLoadedNotifier notifier) {
        byte[] bytes;
        if (!raw.startsWith(START)) {
            throw new IllegalStateException("Invalid data-uri: " + raw);
        }
        String part = raw.substring(START.length());
        DataUri dataUri = this.uriParser.parse(part);
        if (dataUri == null) {
            throw new IllegalStateException("Invalid data-uri: " + raw);
        }
        try {
            bytes = this.uriDecoder.decode(dataUri);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Cannot decode data-uri: " + raw, t);
        }
        if (bytes == null) {
            throw new IllegalStateException("Decoding data-uri failed: " + raw);
        }
        return ImageItem.withDecodingNeeded(dataUri.contentType(), new ByteArrayInputStream(bytes));
    }

    @Override
    @NonNull
    public Collection<String> supportedSchemes() {
        return Collections.singleton(SCHEME);
    }
}

