/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.image.network;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.image.ImageItem;
import io.noties.markwon.image.ImageLoadedNotifier;
import io.noties.markwon.image.SchemeHandler;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class NetworkSchemeHandler
extends SchemeHandler {
    public static final String SCHEME_HTTP = "http";
    public static final String SCHEME_HTTPS = "https";
    private final ConcurrentHashMap<String, ImageItem.WithDecodingNeeded> cachedImageItems = new ConcurrentHashMap();
    private final ExecutorService requestExecutor = Executors.newFixedThreadPool(12);

    public NetworkSchemeHandler() {
        this(false);
    }

    public NetworkSchemeHandler(boolean shouldHandleAsync) {
        this.shouldHandleAsync = shouldHandleAsync;
    }

    @Override
    public ImageItem prefetch(@NonNull String imgUrl, @NonNull Uri uri) {
        return this.cachedImageItems.get(imgUrl);
    }

    @Override
    @NonNull
    public ImageItem handle(@NonNull String raw, @NonNull Uri uri, @Nullable ImageLoadedNotifier notifier) {
        if (this.shouldHandleAsync) {
            return this.onAsyncRequestImage(raw, notifier);
        }
        return this.onSyncRequestImage(raw);
    }

    private ImageItem.WithDecodingNeeded onSyncRequestImage(@NonNull String imgUrl) {
        ImageItem.WithDecodingNeeded imageItem;
        try {
            URL url = new URL(imgUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode < 200 || responseCode >= 300) {
                throw new IOException("Bad response code: " + responseCode + ", url: " + imgUrl);
            }
            String contentType = NetworkSchemeHandler.contentType(connection.getHeaderField("Content-Type"));
            BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());
            imageItem = ImageItem.withDecodingNeeded(contentType, inputStream);
            this.cachedImageItems.put(imgUrl, imageItem);
        }
        catch (IOException e) {
            throw new IllegalStateException("Exception obtaining network resource: " + imgUrl, e);
        }
        return imageItem;
    }

    private ImageItem.WithDecodingNeeded onAsyncRequestImage(@NonNull String imgUrl, @Nullable ImageLoadedNotifier notifier) {
        ImageItem.WithDecodingNeeded previousItem = this.cachedImageItems.get(imgUrl);
        if (previousItem != null) {
            if (previousItem.isProcessing()) {
                return previousItem;
            }
            if (previousItem.getCachedDrawable() != null) {
                return previousItem;
            }
        } else {
            previousItem = new ImageItem.WithDecodingNeeded();
            this.cachedImageItems.put(imgUrl, previousItem);
        }
        ImageItem.WithDecodingNeeded tempItem = previousItem;
        this.requestExecutor.submit(() -> this.doAsyncRequest(imgUrl, tempItem, notifier));
        return previousItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAsyncRequest(@NonNull String imgUrl, ImageItem.WithDecodingNeeded imageItem, @Nullable ImageLoadedNotifier notifier) {
        ImageItem.WithDecodingNeeded resItem = null;
        try {
            URL url = new URL(imgUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode >= 200 && responseCode < 300) {
                String contentType = NetworkSchemeHandler.contentType(connection.getHeaderField("Content-Type"));
                BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());
                resItem = ImageItem.withDecodingNeeded(contentType, inputStream);
                this.cachedImageItems.put(imgUrl, resItem);
            } else {
                imageItem.setIsProcessing(false);
            }
            if (notifier != null) {
                notifier.doNotifyUI(resItem, resItem != null);
            }
        }
        catch (Exception e) {
            try {
                imageItem.setIsProcessing(false);
                if (notifier != null) {
                    notifier.doNotifyUI(resItem, resItem != null);
                }
            }
            catch (Throwable throwable) {
                if (notifier != null) {
                    notifier.doNotifyUI(resItem, resItem != null);
                }
                throw throwable;
            }
        }
    }

    @Override
    @NonNull
    public Collection<String> supportedSchemes() {
        return Arrays.asList(SCHEME_HTTP, SCHEME_HTTPS);
    }

    @Nullable
    static String contentType(@Nullable String contentType) {
        if (contentType == null) {
            return null;
        }
        int index = contentType.indexOf(59);
        if (index > -1) {
            return contentType.substring(0, index);
        }
        return contentType;
    }
}

