/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.image.network;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import io.noties.markwon.image.ImageItem;
import io.noties.markwon.image.ImageLoadedNotifier;
import io.noties.markwon.image.SchemeHandler;
import io.noties.markwon.image.network.NetworkSchemeHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttpNetworkSchemeHandler
extends SchemeHandler {
    private final HashMap<String, ImageItem.WithDecodingNeeded> imgPathMap = new HashMap();
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    private final Call.Factory factory;

    public OkHttpNetworkSchemeHandler() {
        this(false, new OkHttpClient());
    }

    public OkHttpNetworkSchemeHandler(boolean shouldHandleAsync) {
        this(shouldHandleAsync, new OkHttpClient());
    }

    public <T extends Call.Factory> OkHttpNetworkSchemeHandler(@NonNull T factory) {
        this(false, factory);
    }

    public <T extends Call.Factory> OkHttpNetworkSchemeHandler(boolean shouldHandleAsync, @NonNull T factory) {
        this.shouldHandleAsync = shouldHandleAsync;
        this.factory = factory;
    }

    @Override
    public ImageItem prefetch(@NonNull String imgUrl, @NonNull Uri uri) {
        return this.imgPathMap.get(imgUrl);
    }

    @Override
    @NonNull
    public ImageItem handle(@NonNull String raw, @NonNull Uri uri, @Nullable ImageLoadedNotifier notifier) {
        if (this.shouldHandleAsync) {
            return this.doAsyncRequest(raw, notifier);
        }
        return this.doSyncRequest(raw);
    }

    private ImageItem.WithDecodingNeeded doAsyncRequest(final String imgUrl, final @Nullable ImageLoadedNotifier notifier) {
        ImageItem.WithDecodingNeeded previousItem = this.imgPathMap.get(imgUrl);
        if (previousItem != null) {
            if (previousItem.isProcessing()) {
                return previousItem;
            }
            if (previousItem.getCachedDrawable() != null) {
                return previousItem;
            }
        } else {
            previousItem = new ImageItem.WithDecodingNeeded();
            this.imgPathMap.put(imgUrl, previousItem);
        }
        final ImageItem.WithDecodingNeeded tempItem = previousItem;
        Request request = new Request.Builder().url(imgUrl).tag((Object)imgUrl).build();
        this.factory.newCall(request).enqueue(new Callback(){

            public void onFailure(@NonNull Call call, @NonNull IOException e) {
                tempItem.setIsProcessing(false);
                if (notifier != null) {
                    notifier.doNotifyUI(tempItem, false);
                }
            }

            public void onResponse(@NonNull Call call, @NonNull Response response) throws IOException {
                InputStream inputStream;
                ResponseBody body = response.body();
                InputStream inputStream2 = inputStream = body != null ? body.byteStream() : null;
                if (inputStream != null) {
                    String contentType = NetworkSchemeHandler.contentType(response.header(OkHttpNetworkSchemeHandler.HEADER_CONTENT_TYPE));
                    OkHttpNetworkSchemeHandler.this.imgPathMap.put(imgUrl, ImageItem.withDecodingNeeded(contentType, inputStream));
                } else {
                    tempItem.setIsProcessing(false);
                }
                if (notifier != null) {
                    notifier.doNotifyUI(tempItem, tempItem.inputStream() != null);
                }
            }
        });
        return previousItem;
    }

    private ImageItem.WithDecodingNeeded doSyncRequest(String imgUrl) {
        ImageItem.WithDecodingNeeded withDecodingNeeded;
        block9: {
            Request request = new Request.Builder().url(imgUrl).tag((Object)imgUrl).build();
            Response response = this.factory.newCall(request).execute();
            try {
                InputStream inputStream;
                ResponseBody body = response.body();
                InputStream inputStream2 = inputStream = body != null ? body.byteStream() : null;
                if (inputStream == null) {
                    throw new IllegalStateException("Response does not contain body: " + imgUrl);
                }
                String contentType = NetworkSchemeHandler.contentType(response.header(HEADER_CONTENT_TYPE));
                withDecodingNeeded = ImageItem.withDecodingNeeded(contentType, inputStream);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    throw new IllegalStateException("Exception obtaining network resource: " + imgUrl, t);
                }
            }
            response.close();
        }
        return withDecodingNeeded;
    }

    @Override
    @NonNull
    public Collection<String> supportedSchemes() {
        return Arrays.asList("http", "https");
    }
}

