/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.inlineparser;

import io.noties.markwon.inlineparser.InlineParserUtils;
import io.noties.markwon.inlineparser.InlineProcessor;
import io.noties.markwon.inlineparser.MarkwonInlineParser;
import java.util.regex.Pattern;
import org.commonmark.internal.Bracket;
import org.commonmark.internal.util.Escaping;
import org.commonmark.node.Image;
import org.commonmark.node.Link;
import org.commonmark.node.LinkReferenceDefinition;
import org.commonmark.node.Node;

public class CloseBracketInlineProcessor
extends InlineProcessor {
    private static final Pattern WHITESPACE = MarkwonInlineParser.WHITESPACE;

    @Override
    public char specialCharacter() {
        return ']';
    }

    @Override
    protected Node parse() {
        ++this.index;
        int startIndex = this.index++;
        Bracket opener = this.lastBracket();
        if (opener == null) {
            return this.text("]");
        }
        if (!opener.allowed) {
            this.removeLastBracket();
            return this.text("]");
        }
        String dest = null;
        String title = null;
        boolean isLinkOrImage = false;
        if (this.peek() == '(') {
            this.spnl();
            dest = this.parseLinkDestination();
            if (dest != null) {
                this.spnl();
                if (WHITESPACE.matcher(this.input.substring(this.index - 1, this.index)).matches()) {
                    title = this.parseLinkTitle();
                    this.spnl();
                }
                if (this.peek() == ')') {
                    ++this.index;
                    isLinkOrImage = true;
                } else {
                    this.index = startIndex;
                }
            }
        }
        if (!isLinkOrImage) {
            String label;
            LinkReferenceDefinition definition;
            int beforeLabel = this.index;
            this.parseLinkLabel();
            int labelLength = this.index - beforeLabel;
            String ref = null;
            if (labelLength > 2) {
                ref = this.input.substring(beforeLabel, beforeLabel + labelLength);
            } else if (!opener.bracketAfter) {
                ref = this.input.substring(opener.index, startIndex);
            }
            if (ref != null && (definition = this.context.getLinkReferenceDefinition(label = Escaping.normalizeReference(ref))) != null) {
                dest = definition.getDestination();
                title = definition.getTitle();
                isLinkOrImage = true;
            }
        }
        if (isLinkOrImage) {
            Image linkOrImage = opener.image ? new Image(dest, title) : new Link(dest, title);
            Node node = opener.node.getNext();
            while (node != null) {
                Node next = node.getNext();
                linkOrImage.appendChild(node);
                node = next;
            }
            this.processDelimiters(opener.previousDelimiter);
            InlineParserUtils.mergeChildTextNodes((Node)linkOrImage);
            opener.node.unlink();
            this.removeLastBracket();
            if (!opener.image) {
                Bracket bracket = this.lastBracket();
                while (bracket != null) {
                    if (!bracket.image) {
                        bracket.allowed = false;
                    }
                    bracket = bracket.previous;
                }
            }
            return linkOrImage;
        }
        this.index = startIndex;
        this.removeLastBracket();
        return this.text("]");
    }
}

