/*
 * Decompiled with CFR 0.152.
 */
package me.nereo.multi_image_selector.adapter;

import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import me.nereo.multi_image_selector.R;
import me.nereo.multi_image_selector.bean.Image;

public class ImageGridAdapter
extends BaseAdapter {
    private static final int TYPE_CAMERA = 0;
    private static final int TYPE_NORMAL = 1;
    final int mGridWidth;
    private Context mContext;
    private LayoutInflater mInflater;
    private boolean showCamera = true;
    private boolean showSelectIndicator = true;
    private final RequestOptions mGlideOptions;
    private List<Image> mImages = new ArrayList<Image>();
    private List<Image> mSelectedImages = new ArrayList<Image>();

    public ImageGridAdapter(Context context, boolean showCamera, int column) {
        this.mContext = context;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.showCamera = showCamera;
        WindowManager wm = (WindowManager)context.getSystemService("window");
        int width = 0;
        if (Build.VERSION.SDK_INT >= 13) {
            Point size = new Point();
            wm.getDefaultDisplay().getSize(size);
            width = size.x;
        } else {
            width = wm.getDefaultDisplay().getWidth();
        }
        this.mGridWidth = width / column;
        this.mGlideOptions = new RequestOptions().placeholder(R.drawable.mis_default_error);
    }

    public void showSelectIndicator(boolean b) {
        this.showSelectIndicator = b;
    }

    public boolean isShowCamera() {
        return this.showCamera;
    }

    public void setShowCamera(boolean b) {
        if (this.showCamera == b) {
            return;
        }
        this.showCamera = b;
        this.notifyDataSetChanged();
    }

    public void select(Image image) {
        if (this.mSelectedImages.contains(image)) {
            this.mSelectedImages.remove(image);
        } else {
            this.mSelectedImages.add(image);
        }
        this.notifyDataSetChanged();
    }

    public void setDefaultSelected(ArrayList<String> resultList) {
        for (String path : resultList) {
            Image image = this.getImageByPath(path);
            if (image == null) continue;
            this.mSelectedImages.add(image);
        }
        if (this.mSelectedImages.size() > 0) {
            this.notifyDataSetChanged();
        }
    }

    private Image getImageByPath(String path) {
        if (this.mImages != null && this.mImages.size() > 0) {
            for (Image image : this.mImages) {
                if (!image.path.equalsIgnoreCase(path)) continue;
                return image;
            }
        }
        return null;
    }

    public void setData(List<Image> images) {
        this.mSelectedImages.clear();
        if (images != null && images.size() > 0) {
            this.mImages = images;
        } else {
            this.mImages.clear();
        }
        this.notifyDataSetChanged();
    }

    public int getViewTypeCount() {
        return 2;
    }

    public int getItemViewType(int position) {
        if (this.showCamera) {
            return position == 0 ? 0 : 1;
        }
        return 1;
    }

    public int getCount() {
        return this.showCamera ? this.mImages.size() + 1 : this.mImages.size();
    }

    public Image getItem(int i) {
        if (this.showCamera) {
            if (i == 0) {
                return null;
            }
            return this.mImages.get(i - 1);
        }
        return this.mImages.get(i);
    }

    public long getItemId(int i) {
        return i;
    }

    public View getView(int i, View view, ViewGroup viewGroup) {
        ViewHolder holder;
        if (this.isShowCamera() && i == 0) {
            view = this.mInflater.inflate(R.layout.mis_list_item_camera, viewGroup, false);
            return view;
        }
        if (view == null) {
            view = this.mInflater.inflate(R.layout.mis_list_item_image, viewGroup, false);
            holder = new ViewHolder(view);
        } else {
            holder = (ViewHolder)view.getTag();
        }
        if (holder != null) {
            holder.bindData(this.getItem(i));
        }
        return view;
    }

    class ViewHolder {
        ImageView image;
        ImageView indicator;
        View mask;

        ViewHolder(View view) {
            this.image = (ImageView)view.findViewById(R.id.image);
            this.indicator = (ImageView)view.findViewById(R.id.checkmark);
            this.mask = view.findViewById(R.id.mask);
            view.setTag((Object)this);
        }

        void bindData(Image data) {
            if (data == null) {
                return;
            }
            if (ImageGridAdapter.this.showSelectIndicator) {
                this.indicator.setVisibility(0);
                if (ImageGridAdapter.this.mSelectedImages.contains(data)) {
                    this.indicator.setImageResource(R.drawable.mis_btn_selected);
                    this.mask.setVisibility(0);
                } else {
                    this.indicator.setImageResource(R.drawable.mis_btn_unselected);
                    this.mask.setVisibility(8);
                }
            } else {
                this.indicator.setVisibility(8);
            }
            File imageFile = new File(data.path);
            if (imageFile.exists()) {
                Glide.with((Context)ImageGridAdapter.this.mContext).load(imageFile).apply(ImageGridAdapter.this.mGlideOptions).into(this.image);
            } else {
                this.image.setImageResource(R.drawable.mis_default_error);
            }
        }
    }
}

