/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.broadcast;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;

public class MessageBroadcastReceiver
extends BroadcastReceiver {
    public static final String ACTION = "com.edusoho.videoplayer.message";
    private Callback mCallback;

    public MessageBroadcastReceiver(Callback callback) {
        this.mCallback = callback;
    }

    public void onReceive(Context context, Intent intent) {
        if (this.mCallback != null) {
            String type = intent.getStringExtra("type");
            String message = intent.getStringExtra("message");
            this.mCallback.onReceive(type, message);
        }
    }

    public static Intent getIntent(String type, String message) {
        Intent intent = new Intent(ACTION);
        intent.putExtra("type", type);
        intent.putExtra("message", message);
        return intent;
    }

    public static interface Callback {
        public void onReceive(String var1, String var2);
    }
}

