/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.cache;

import android.content.Context;
import android.util.Log;
import com.edusoho.videoplayer.cache.WorkThread;
import com.edusoho.videoplayer.cache.handler.FileHandler;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpServerConnection;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.DefaultHttpServerConnection;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerRegistry;
import org.apache.http.protocol.HttpRequestHandlerResolver;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;

public class CacheServer
extends Thread {
    public static final String TAG = "CacheServer";
    private int port = 9900;
    private boolean isLoop;
    private boolean isPause;
    private Context mContext;
    private ServerSocket mServerSocket;
    private HttpRequestHandlerRegistry mHttpRequestHandlerRegistry;
    private ArrayList<Thread> mThreadList;

    public CacheServer(Context context) {
        this.mContext = context;
        this.mThreadList = new ArrayList();
        this.mHttpRequestHandlerRegistry = new HttpRequestHandlerRegistry();
    }

    public CacheServer(Context context, int port) {
        this(context);
        this.port = port;
    }

    public void addHandler(String filter, HttpRequestHandler handler) {
        this.mHttpRequestHandlerRegistry.register(filter, handler);
    }

    @Override
    public synchronized void start() {
        if (this.isLoop) {
            return;
        }
        super.start();
    }

    @Override
    public void run() {
        if (this.isLoop) {
            return;
        }
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        this.mServerSocket = null;
        try {
            this.mServerSocket = new ServerSocket(this.port);
            BasicHttpProcessor httpproc = new BasicHttpProcessor();
            httpproc.addInterceptor((HttpResponseInterceptor)new ResponseDate());
            httpproc.addInterceptor((HttpResponseInterceptor)new ResponseServer());
            httpproc.addInterceptor((HttpResponseInterceptor)new ResponseContent());
            httpproc.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
            HttpService httpService = new HttpService((HttpProcessor)httpproc, (ConnectionReuseStrategy)new DefaultConnectionReuseStrategy(), (HttpResponseFactory)new DefaultHttpResponseFactory());
            BasicHttpParams params = new BasicHttpParams();
            params.setIntParameter("http.socket.timeout", 5000).setIntParameter("http.socket.buffer-size", 8192).setBooleanParameter("http.connection.stalecheck", false).setBooleanParameter("http.tcp.nodelay", true).setParameter("http.origin-server", (Object)"Android Server/1.1");
            httpService.setParams((HttpParams)params);
            this.mHttpRequestHandlerRegistry.register("*", (HttpRequestHandler)new FileHandler("", this.mContext));
            httpService.setHandlerResolver((HttpRequestHandlerResolver)this.mHttpRequestHandlerRegistry);
            this.isLoop = true;
            while (this.isLoop && !Thread.interrupted()) {
                Log.d((String)TAG, (String)("serverSocket.accept pause:" + this.isPause));
                if (this.isPause) continue;
                Socket socket = this.mServerSocket.accept();
                DefaultHttpServerConnection conn = new DefaultHttpServerConnection();
                conn.bind(socket, (HttpParams)params);
                WorkThread t = new WorkThread(httpService, (HttpServerConnection)conn);
                t.setDaemon(true);
                t.start();
                this.mThreadList.add(t);
                Log.d((String)TAG, (String)"WorkThread Start");
            }
        }
        catch (IOException e) {
            this.isLoop = false;
        }
        finally {
            try {
                if (this.mServerSocket != null) {
                    this.mServerSocket.close();
                    Log.d(null, (String)"mServerSocket close");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void pause() {
        this.isPause = true;
    }

    public void keepOn() {
        this.isPause = false;
    }

    public void close() {
        Log.d((String)TAG, (String)"Cache exit");
        this.isLoop = false;
        try {
            for (Thread t : this.mThreadList) {
                t.interrupt();
            }
            this.mThreadList.clear();
            this.mServerSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

