/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.cache;

import android.text.TextUtils;
import com.edusoho.videoplayer.util.DigestUtils;
import java.io.IOException;
import java.io.InputStream;

public class DigestInputStream
extends InputStream {
    private InputStream mTargetInputStream;
    private int mCurrentDigestIndex;
    private byte[] mDigestKey;

    public DigestInputStream(InputStream target, String host) {
        this.initDigestKey(host, true);
        this.mTargetInputStream = target;
    }

    public DigestInputStream(InputStream target, String host, boolean isMd5) {
        this.initDigestKey(host, isMd5);
        this.mTargetInputStream = target;
    }

    private void initDigestKey(String host, boolean isMd5) {
        String digestStr = host;
        if (isMd5 && !TextUtils.isEmpty((CharSequence)host)) {
            digestStr = DigestUtils.md5(host);
        }
        this.mCurrentDigestIndex = 0;
        this.mDigestKey = digestStr.getBytes();
    }

    @Override
    public int read() throws IOException {
        int length = this.mTargetInputStream.read();
        byte[] buffer = new byte[]{(byte)length};
        this.processorByteArray(1, buffer);
        return buffer[0];
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        int length = this.mTargetInputStream.read(buffer);
        this.processorByteArray(length, buffer);
        return length;
    }

    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        int length = this.mTargetInputStream.read(buffer, byteOffset, byteCount);
        this.processorByteArray(length, buffer);
        return length;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.mTargetInputStream.close();
    }

    private void processorByteArray(int length, byte[] buffer) {
        if (length <= 0 || this.mDigestKey.length == 0) {
            return;
        }
        int keyLength = this.mDigestKey.length - 1;
        for (int i = 0; i < length; ++i) {
            byte b = buffer[i];
            this.mCurrentDigestIndex = this.mCurrentDigestIndex > keyLength ? 0 : this.mCurrentDigestIndex;
            buffer[i] = b = (byte)(b ^ this.mDigestKey[this.mCurrentDigestIndex++]);
        }
    }
}

