/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.helper;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.media.AudioManager;
import android.provider.Settings;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.InputDevice;
import android.view.MotionEvent;
import android.view.WindowManager;
import androidx.core.view.GestureDetectorCompat;
import com.edusoho.videoplayer.util.AndroidDevices;
import com.edusoho.videoplayer.util.Permissions;
import com.edusoho.videoplayer.view.VideoControllerView;
import java.lang.ref.WeakReference;

public class ControllerViewTouchHelper {
    private int mAudioMax;
    private int mVolSave;
    private float mVol;
    private boolean mMute = false;
    private AudioManager mAudioManager;
    private WeakReference<Activity> mActivityRef;
    private static final int JOYSTICK_INPUT_DELAY = 300;
    private long mLastMove;
    private static final int TOUCH_NONE = 0;
    private static final int TOUCH_VOLUME = 1;
    private static final int TOUCH_BRIGHTNESS = 2;
    private static final int TOUCH_SEEK = 3;
    private int mTouchAction = 0;
    private int mSurfaceYDisplayRange;
    private float mInitTouchY;
    private float mTouchY = -1.0f;
    private float mTouchX = -1.0f;
    private boolean mIsFirstBrightnessGesture = true;
    private float mRestoreAutoBrightness = -1.0f;
    private int mTouchControls = 0;
    private GestureDetectorCompat mDetector = null;
    private VideoControllerView mControllerView;
    private int mVideoWidth;
    private int mVideoHeight;
    private long mTime;
    private long mLength;

    public ControllerViewTouchHelper(Activity activity) {
        if (activity == null) {
            return;
        }
        this.mAudioManager = (AudioManager)activity.getSystemService("audio");
        this.mAudioMax = this.mAudioManager.getStreamMaxVolume(3);
        this.mActivityRef = new WeakReference<Activity>(activity);
    }

    public void setControllerView(VideoControllerView controllerView) {
        this.mControllerView = controllerView;
    }

    public void updateTimeLength(long time, long length) {
        this.mTime = time;
        this.mLength = length;
    }

    public void updateVideoSize(int w, int h) {
        this.mVideoWidth = w;
        this.mVideoHeight = h;
    }

    private void doSeekTouch(int coef, float gesturesize, boolean seek) {
        Log.d((String)"videotest", (String)("coef: " + coef + " ,gesturesize: " + gesturesize + coef + " ,seek: " + seek));
        if (coef == 0) {
            coef = 1;
        }
        if (Math.abs(gesturesize) < 1.0f) {
            return;
        }
        if (this.mTouchAction != 0 && this.mTouchAction != 3) {
            return;
        }
        this.mTouchAction = 3;
        int jump = (int)((double)Math.signum(gesturesize) * (600000.0 * Math.pow(gesturesize / 8.0f, 4.0) + 3000.0) / (double)coef);
        if (jump > 0 && this.mTime + (long)jump > this.mLength) {
            jump = (int)(this.mLength - this.mTime);
        }
        if (jump < 0 && this.mTime + (long)jump < 0L) {
            jump = (int)(-this.mTime);
        }
        if (seek && this.mLength > 0L) {
            this.mControllerView.onSeek((int)(this.mTime + (long)jump));
        }
        this.mControllerView.getSeekChangeBarView().showInfo(coef, jump, this.mTime, this.mLength);
    }

    private void setAudioVolume(int vol) {
        this.mAudioManager.setStreamVolume(3, vol, 0);
        int newVol = this.mAudioManager.getStreamVolume(3);
        if (vol != newVol) {
            this.mAudioManager.setStreamVolume(3, vol, 1);
        }
        this.mAudioManager.adjustStreamVolume(3, -1, 1);
    }

    private void changeBrightness(float delta) {
        Activity activity = (Activity)this.mActivityRef.get();
        if (activity == null) {
            return;
        }
        WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
        float brightness = Math.min(Math.max(lp.screenBrightness + delta, 0.01f), 1.0f);
        this.setWindowBrightness(brightness);
        brightness = Math.round(brightness * 100.0f);
    }

    private void setWindowBrightness(float brightness) {
        Activity activity = (Activity)this.mActivityRef.get();
        if (activity == null) {
            return;
        }
        WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
        lp.screenBrightness = brightness;
        activity.getWindow().setAttributes(lp);
    }

    private void initBrightnessTouch() {
        Activity activity = (Activity)this.mActivityRef.get();
        if (activity == null) {
            return;
        }
        WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
        float brightnesstemp = lp.screenBrightness != -1.0f ? lp.screenBrightness : 0.6f;
        try {
            if (Settings.System.getInt((ContentResolver)activity.getContentResolver(), (String)"screen_brightness_mode") == 1) {
                if (!Permissions.canWriteSettings((Context)activity)) {
                    Permissions.checkWriteSettingsPermission(activity, 43);
                    return;
                }
                Settings.System.putInt((ContentResolver)activity.getContentResolver(), (String)"screen_brightness_mode", (int)0);
                this.mRestoreAutoBrightness = (float)Settings.System.getInt((ContentResolver)activity.getContentResolver(), (String)"screen_brightness") / 255.0f;
            } else if (brightnesstemp == 0.6f) {
                brightnesstemp = (float)Settings.System.getInt((ContentResolver)activity.getContentResolver(), (String)"screen_brightness") / 255.0f;
            }
        }
        catch (Settings.SettingNotFoundException e) {
            e.printStackTrace();
        }
        lp.screenBrightness = brightnesstemp;
        activity.getWindow().setAttributes(lp);
        this.mIsFirstBrightnessGesture = false;
    }

    private void seekDelta(int delta) {
    }

    private void doBrightnessTouch(float y_changed) {
        if (this.mTouchAction != 0 && this.mTouchAction != 2) {
            return;
        }
        if (this.mIsFirstBrightnessGesture) {
            this.initBrightnessTouch();
        }
        this.mTouchAction = 2;
        float delta = -y_changed / (float)this.mSurfaceYDisplayRange;
        this.changeBrightness(delta);
    }

    private void doVolumeTouch(float y_changed) {
        if (this.mTouchAction != 0 && this.mTouchAction != 1) {
            return;
        }
        float delta = -(y_changed / (float)this.mSurfaceYDisplayRange * (float)this.mAudioMax);
        this.mVol += delta;
        int vol = (int)Math.min(Math.max(this.mVol, 0.0f), (float)this.mAudioMax);
        if (delta != 0.0f) {
            this.setAudioVolume(vol);
        }
    }

    private void sendMouseEvent(int action, int button, int x, int y) {
    }

    public boolean dispatchGenericMotionEvent(MotionEvent event) {
        Log.d((String)"touchHelper", (String)"dispatchGenericMotionEvent");
        if ((event.getSource() & 0x1000010) != 0x1000010 || event.getAction() != 2) {
            return false;
        }
        InputDevice mInputDevice = event.getDevice();
        float dpadx = event.getAxisValue(15);
        float dpady = event.getAxisValue(16);
        if (mInputDevice == null || Math.abs(dpadx) == 1.0f || Math.abs(dpady) == 1.0f) {
            return false;
        }
        float x = AndroidDevices.getCenteredAxis(event, mInputDevice, 0);
        float y = AndroidDevices.getCenteredAxis(event, mInputDevice, 1);
        float rz = AndroidDevices.getCenteredAxis(event, mInputDevice, 14);
        if (System.currentTimeMillis() - this.mLastMove > 300L) {
            if ((double)Math.abs(x) > 0.3) {
                this.seekDelta(x > 0.0f ? 10000 : -10000);
            } else if ((double)Math.abs(y) > 0.3) {
                if (this.mIsFirstBrightnessGesture) {
                    this.initBrightnessTouch();
                }
                this.changeBrightness(-y / 10.0f);
            } else if ((double)Math.abs(rz) > 0.3) {
                this.mVol = this.mAudioManager.getStreamVolume(3);
                int delta = -((int)(rz / 7.0f * (float)this.mAudioMax));
                int vol = (int)Math.min(Math.max(this.mVol + (float)delta, 0.0f), (float)this.mAudioMax);
                this.setAudioVolume(vol);
            }
            this.mLastMove = System.currentTimeMillis();
        }
        return true;
    }

    public boolean onTouchEvent(MotionEvent event) {
        float x_changed;
        float y_changed;
        DisplayMetrics screen = new DisplayMetrics();
        ((Activity)this.mActivityRef.get()).getWindowManager().getDefaultDisplay().getMetrics(screen);
        if (this.mSurfaceYDisplayRange == 0) {
            this.mSurfaceYDisplayRange = Math.min(screen.widthPixels, screen.heightPixels);
        }
        if (this.mTouchX != -1.0f && this.mTouchY != -1.0f) {
            y_changed = event.getRawY() - this.mTouchY;
            x_changed = event.getRawX() - this.mTouchX;
        } else {
            x_changed = 0.0f;
            y_changed = 0.0f;
        }
        float coef = Math.abs(y_changed / x_changed);
        float xgesturesize = x_changed / screen.xdpi * 2.54f;
        float delta_y = Math.max(1.0f, (Math.abs(this.mInitTouchY - event.getRawY()) / screen.xdpi + 0.5f) * 2.0f);
        int[] offset = new int[2];
        this.mControllerView.getLocationOnScreen(offset);
        int xTouch = Math.round((event.getRawX() - (float)offset[0]) * (float)this.mVideoWidth / (float)this.mControllerView.getWidth());
        int yTouch = Math.round((event.getRawY() - (float)offset[1]) * (float)this.mVideoHeight / (float)this.mControllerView.getHeight());
        switch (event.getAction()) {
            case 0: {
                this.mTouchY = this.mInitTouchY = event.getRawY();
                this.mVol = this.mAudioManager.getStreamVolume(3);
                this.mTouchAction = 0;
                this.mTouchX = event.getRawX();
                this.sendMouseEvent(0, 0, xTouch, yTouch);
                break;
            }
            case 2: {
                this.sendMouseEvent(2, 0, xTouch, yTouch);
                Log.d((String)"touchHelper", (String)("mTouchY:" + this.mTouchY));
                if (this.mTouchAction != 3 && coef > 2.0f) {
                    if ((double)Math.abs(y_changed / (float)this.mSurfaceYDisplayRange) < 0.05) {
                        return false;
                    }
                    this.mTouchY = event.getRawY();
                    this.mTouchX = event.getRawX();
                    if (this.mTouchControls == 1 || (int)this.mTouchX > 3 * screen.widthPixels / 5) {
                        this.doVolumeTouch(y_changed);
                        break;
                    }
                    if ((int)this.mTouchX >= 2 * screen.widthPixels / 5) break;
                    Log.d((String)"touchHelper", (String)"doBrightnessTouch");
                    this.doBrightnessTouch(y_changed);
                    break;
                }
                this.doSeekTouch(Math.round(delta_y), xgesturesize, false);
                break;
            }
            case 1: 
            case 3: {
                this.sendMouseEvent(1, 0, xTouch, yTouch);
                if (this.mTouchAction == 0) {
                    return false;
                }
                if (this.mTouchAction == 3) {
                    this.doSeekTouch(Math.round(delta_y), xgesturesize, true);
                }
                this.mTouchX = -1.0f;
                this.mTouchY = -1.0f;
            }
        }
        return this.mTouchAction != 0;
    }
}

