/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.media;

import android.content.Context;
import android.os.Handler;
import androidx.annotation.Nullable;
import com.edusoho.videoplayer.media.sonic.SonicMediaCodecAudioTrackRenderer;
import com.edusoho.videoplayer.util.Util;
import com.google.android.exoplayer2.DefaultRenderersFactory;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.RenderersFactory;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.analytics.AnalyticsCollector;
import com.google.android.exoplayer2.audio.AudioCapabilities;
import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.audio.AudioRendererEventListener;
import com.google.android.exoplayer2.audio.MediaCodecAudioRenderer;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.drm.FrameworkMediaCrypto;
import com.google.android.exoplayer2.mediacodec.MediaCodecSelector;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import java.util.ArrayList;

public class EduExoPlayer
extends SimpleExoPlayer {
    private static SonicMediaCodecAudioTrackRenderer mSonicMediaCodecAudioTrackRenderer;

    public EduExoPlayer(Context context, BandwidthMeter bandwidthMeter, TrackSelector trackSelector, LoadControl loadControl, @Nullable DrmSessionManager<FrameworkMediaCrypto> drmSessionManager) {
        super(context, (RenderersFactory)new DefaultRenderersFactory(context){

            protected void buildAudioRenderers(Context context, int extensionRendererMode, MediaCodecSelector mediaCodecSelector, @Nullable DrmSessionManager<FrameworkMediaCrypto> drmSessionManager, boolean playClearSamplesWithoutKeys, boolean enableDecoderFallback, AudioProcessor[] audioProcessors, Handler eventHandler, AudioRendererEventListener eventListener, ArrayList<Renderer> out) {
                super.buildAudioRenderers(context, extensionRendererMode, mediaCodecSelector, drmSessionManager, playClearSamplesWithoutKeys, enableDecoderFallback, audioProcessors, eventHandler, eventListener, out);
                EduExoPlayer.handle(context, (DrmSessionManager<FrameworkMediaCrypto>)drmSessionManager, eventHandler, eventListener, out);
            }
        }, trackSelector, loadControl, drmSessionManager, bandwidthMeter, new AnalyticsCollector.Factory(), Util.getLooper());
    }

    private static void handle(Context context, @Nullable DrmSessionManager<FrameworkMediaCrypto> drmSessionManager, Handler eventHandler, AudioRendererEventListener eventListener, ArrayList<Renderer> out) {
        int size = out.size();
        for (int i = 0; i < size; ++i) {
            Renderer render = out.get(i);
            if (!(render instanceof MediaCodecAudioRenderer)) continue;
            if (com.google.android.exoplayer2.util.Util.SDK_INT < 23) {
                out.remove(i);
                mSonicMediaCodecAudioTrackRenderer = new SonicMediaCodecAudioTrackRenderer(context, MediaCodecSelector.DEFAULT, drmSessionManager, true, eventHandler, eventListener, AudioCapabilities.getCapabilities((Context)context));
                out.add((Renderer)mSonicMediaCodecAudioTrackRenderer);
            }
            return;
        }
    }

    public void setRate(float speed) {
        if (com.google.android.exoplayer2.util.Util.SDK_INT < 23) {
            mSonicMediaCodecAudioTrackRenderer.setPlaybackSpeed(speed);
        } else {
            this.setPlaybackParameters(new PlaybackParameters(speed));
        }
    }
}

