/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.media.encrypt;

import android.text.TextUtils;
import com.edusoho.videoplayer.util.DigestUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DigestInputStream
extends RandomAccessFile {
    private int mCurrentDigestIndex;
    private byte[] mDigestKey;
    private String fileName;

    public DigestInputStream(File file, String mode, String host) throws FileNotFoundException {
        super(file, mode);
        this.fileName = file.getPath();
        this.initDigestKey(host, true);
    }

    private void initDigestKey(String host, boolean isMd5) {
        String digestStr = host;
        if (isMd5 && !TextUtils.isEmpty((CharSequence)host)) {
            digestStr = DigestUtils.md5(host);
        }
        this.mCurrentDigestIndex = 0;
        this.mDigestKey = digestStr.getBytes();
    }

    @Override
    public int read() throws IOException {
        int length = super.read();
        byte[] buffer = new byte[]{(byte)length};
        this.processorByteArray(1, buffer);
        return buffer[0];
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        int length = super.read(buffer);
        this.processorByteArray(length, buffer);
        return length;
    }

    @Override
    public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
        int length = super.read(buffer, byteOffset, byteCount);
        this.processorByteArray(length, buffer);
        return length;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    private void processorByteArray(int length, byte[] buffer) {
        if (length <= 0 || this.mDigestKey.length == 0) {
            return;
        }
        int keyLength = this.mDigestKey.length - 1;
        for (int i = 0; i < length; ++i) {
            byte b = buffer[i];
            this.mCurrentDigestIndex = this.mCurrentDigestIndex > keyLength ? 0 : this.mCurrentDigestIndex;
            buffer[i] = b = (byte)(b ^ this.mDigestKey[this.mCurrentDigestIndex++]);
        }
    }
}

