/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.media.encrypt;

import android.content.Context;
import android.net.Uri;
import com.edusoho.videoplayer.media.encrypt.EncryptFileDataSource;
import com.google.android.exoplayer2.upstream.AssetDataSource;
import com.google.android.exoplayer2.upstream.ContentDataSource;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;

public class EncryptDataSource
implements DataSource {
    private static final String SCHEME_ASSET = "asset";
    private static final String SCHEME_CONTENT = "content";
    private static final String SCHEME_STRING = "string";
    private final DataSource baseDataSource;
    private final DataSource fileDataSource;
    private final DataSource assetDataSource;
    private final DataSource contentDataSource;
    private DataSource dataSource;

    public EncryptDataSource(Context context, String digestKey, TransferListener listener, DataSource baseDataSource) {
        this.baseDataSource = (DataSource)Assertions.checkNotNull((Object)baseDataSource);
        this.fileDataSource = new EncryptFileDataSource(context, digestKey, listener);
        this.assetDataSource = new AssetDataSource(context, listener);
        this.contentDataSource = new ContentDataSource(context, listener);
    }

    public long open(DataSpec dataSpec) throws IOException {
        Assertions.checkState((this.dataSource == null ? 1 : 0) != 0);
        String scheme = dataSpec.uri.getScheme();
        this.dataSource = Util.isLocalFileUri((Uri)dataSpec.uri) ? (dataSpec.uri.getPath().startsWith("/android_asset/") ? this.assetDataSource : this.fileDataSource) : (SCHEME_ASSET.equals(scheme) ? this.assetDataSource : (SCHEME_CONTENT.equals(scheme) ? this.contentDataSource : this.baseDataSource));
        return this.dataSource.open(dataSpec);
    }

    public int read(byte[] buffer, int offset, int readLength) throws IOException {
        return this.dataSource.read(buffer, offset, readLength);
    }

    public Uri getUri() {
        return this.dataSource == null ? null : this.dataSource.getUri();
    }

    public void close() throws IOException {
        if (this.dataSource != null) {
            try {
                this.dataSource.close();
            }
            finally {
                this.dataSource = null;
            }
        }
    }

    public void addTransferListener(TransferListener transferListener) {
    }
}

