/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.media.encrypt;

import android.content.Context;
import android.net.Uri;
import com.edusoho.videoplayer.broadcast.MessageBroadcastReceiver;
import com.edusoho.videoplayer.media.encrypt.DigestInputStream;
import com.edusoho.videoplayer.media.encrypt.EncrpytRandomAccessFile;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.TransferListener;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class EncryptFileDataSource
implements DataSource {
    private final TransferListener listener;
    private RandomAccessFile file;
    private Uri uri;
    private String digestKey;
    private long bytesRemaining;
    private boolean opened;
    private Context mContext;
    private DataSpec mDataSpec;

    public EncryptFileDataSource() {
        this(null, null, null);
    }

    public EncryptFileDataSource(Context context, String digestKey, TransferListener listener) {
        this.mContext = context;
        this.digestKey = digestKey;
        this.listener = listener;
    }

    public long open(DataSpec dataSpec) throws FileDataSourceException {
        try {
            this.uri = dataSpec.uri;
            this.file = this.getRealRandomAccessFile(this.uri);
            this.file.seek(dataSpec.position);
            long l = this.bytesRemaining = dataSpec.length == -1L ? this.file.length() - dataSpec.position : dataSpec.length;
            if (this.bytesRemaining < 0L) {
                throw new EOFException();
            }
        }
        catch (IOException e) {
            this.mContext.sendBroadcast(MessageBroadcastReceiver.getIntent("FileDataSourceException", this.uri.toString()));
            throw new FileDataSourceException(e);
        }
        this.opened = true;
        if (this.listener != null) {
            this.listener.onTransferStart((DataSource)this, dataSpec, true);
        }
        return this.bytesRemaining;
    }

    private RandomAccessFile getRealRandomAccessFile(Uri uri) throws FileNotFoundException {
        if (uri.getPath().endsWith(".m3u8")) {
            return new RandomAccessFile(new File(uri.getPath()), "r");
        }
        if (uri.getPath().contains("ext_x_key")) {
            return new EncrpytRandomAccessFile(new File(uri.getPath()), "r");
        }
        return new DigestInputStream(new File(uri.getPath()), "r", this.digestKey);
    }

    public int read(byte[] buffer, int offset, int readLength) throws FileDataSourceException {
        int bytesRead;
        if (readLength == 0) {
            return 0;
        }
        if (this.bytesRemaining == 0L) {
            return -1;
        }
        try {
            bytesRead = this.file.read(buffer, offset, (int)Math.min(this.bytesRemaining, (long)readLength));
        }
        catch (IOException e) {
            throw new FileDataSourceException(e);
        }
        if (bytesRead > 0) {
            this.bytesRemaining -= (long)bytesRead;
            if (this.listener != null) {
                this.listener.onBytesTransferred((DataSource)this, this.mDataSpec, true, bytesRead);
            }
        }
        return bytesRead;
    }

    public Uri getUri() {
        return this.uri;
    }

    public void close() throws FileDataSourceException {
        this.uri = null;
        try {
            if (this.file != null) {
                this.file.close();
            }
        }
        catch (IOException e) {
            throw new FileDataSourceException(e);
        }
        finally {
            this.file = null;
            if (this.opened) {
                this.opened = false;
                if (this.listener != null) {
                    this.listener.onTransferEnd((DataSource)this, this.mDataSpec, true);
                }
            }
        }
    }

    public void addTransferListener(TransferListener transferListener) {
    }

    public static class FileDataSourceException
    extends IOException {
        public FileDataSourceException(IOException cause) {
            super(cause);
        }
    }
}

