/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.media.sonic;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Handler;
import com.edusoho.videoplayer.media.sonic.Sonic;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.audio.AudioCapabilities;
import com.google.android.exoplayer2.audio.AudioProcessor;
import com.google.android.exoplayer2.audio.AudioRendererEventListener;
import com.google.android.exoplayer2.audio.MediaCodecAudioRenderer;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.drm.FrameworkMediaCrypto;
import com.google.android.exoplayer2.mediacodec.MediaCodecSelector;
import java.nio.ByteBuffer;

public final class SonicMediaCodecAudioTrackRenderer
extends MediaCodecAudioRenderer {
    private Sonic sonic;
    private float speed = 1.0f;
    private byte[] inBuffer;
    private byte[] outBuffer;
    private ByteBuffer bufferSonicOut;
    private int bufferIndex = -1;

    public SonicMediaCodecAudioTrackRenderer(Context context, MediaCodecSelector mediaCodecSelector, DrmSessionManager<FrameworkMediaCrypto> drmSessionManager, boolean playClearSamplesWithoutKeys, Handler eventHandler, AudioRendererEventListener eventListener, AudioCapabilities audioCapabilities) {
        super(context, mediaCodecSelector, drmSessionManager, playClearSamplesWithoutKeys, eventHandler, eventListener, audioCapabilities, new AudioProcessor[0]);
    }

    @TargetApi(value=16)
    protected final void onOutputFormatChanged(MediaCodec codec, MediaFormat outputFormat) throws ExoPlaybackException {
        super.onOutputFormatChanged(codec, outputFormat);
        int sampleRate = outputFormat.getInteger("sample-rate");
        int channelCount = outputFormat.getInteger("channel-count");
        int bufferSize = channelCount * 4096;
        this.inBuffer = new byte[bufferSize];
        this.outBuffer = new byte[bufferSize];
        this.sonic = new Sonic(sampleRate, channelCount);
        this.bufferSonicOut = ByteBuffer.wrap(this.outBuffer, 0, 0);
        this.setSpeed(this.speed);
    }

    protected boolean processOutputBuffer(long positionUs, long elapsedRealtimeUs, MediaCodec codec, ByteBuffer buffer, int bufferIndex, int bufferFlags, long bufferPresentationTimeUs, boolean isDecodeOnlyBuffer, boolean isLastBuffer, Format format) throws ExoPlaybackException {
        if (bufferIndex == this.bufferIndex) {
            return super.processOutputBuffer(positionUs, elapsedRealtimeUs, codec, this.bufferSonicOut, bufferIndex, bufferFlags, bufferPresentationTimeUs, isDecodeOnlyBuffer, isLastBuffer, format);
        }
        this.bufferIndex = bufferIndex;
        int sizeSonic = buffer.remaining();
        buffer.get(this.inBuffer, 0, sizeSonic);
        this.sonic.writeBytesToStream(this.inBuffer, sizeSonic);
        sizeSonic = this.sonic.readBytesFromStream(this.outBuffer, this.outBuffer.length);
        this.bufferSonicOut.position(0);
        this.bufferSonicOut.limit(sizeSonic);
        return super.processOutputBuffer(positionUs, elapsedRealtimeUs, codec, this.bufferSonicOut, bufferIndex, bufferFlags, bufferPresentationTimeUs, isDecodeOnlyBuffer, isLastBuffer, format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSonicSpeed(float speed) {
        SonicMediaCodecAudioTrackRenderer sonicMediaCodecAudioTrackRenderer = this;
        synchronized (sonicMediaCodecAudioTrackRenderer) {
            try {
                this.speed = speed;
                if (this.sonic != null) {
                    this.sonic.setSpeed(speed);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public float getSonicSpeed() {
        return this.sonic.getSpeed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSonicPitch(float pitch) {
        SonicMediaCodecAudioTrackRenderer sonicMediaCodecAudioTrackRenderer = this;
        synchronized (sonicMediaCodecAudioTrackRenderer) {
            try {
                if (this.sonic != null) {
                    this.sonic.setPitch(pitch);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSonicRate(float rate) {
        SonicMediaCodecAudioTrackRenderer sonicMediaCodecAudioTrackRenderer = this;
        synchronized (sonicMediaCodecAudioTrackRenderer) {
            try {
                if (this.sonic != null) {
                    this.sonic.setRate(rate);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public void setPlaybackSpeed(float speed) {
        this.setSpeed(speed);
    }

    private void setSpeed(float speed) {
        this.speed = speed;
        this.setSonicSpeed(speed);
        this.setSonicPitch(1.0f);
        this.setSonicRate(1.0f);
    }
}

