/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.service;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import com.edusoho.videoplayer.media.MediaWrapper;
import com.edusoho.videoplayer.service.IPlayerService;
import com.edusoho.videoplayer.service.PlayServiceBinder;
import com.edusoho.videoplayer.service.listener.PlayCallback;
import com.edusoho.videoplayer.util.MediaEvent;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.ProgressiveMediaSource;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.util.Util;
import java.util.ArrayList;
import java.util.List;

public class AudioPlayerService
extends Service
implements IPlayerService {
    private final String TAG = "AudioPlayerService";
    private int mCurrentIndex;
    private final IBinder mBinder = new LocalBinder();
    private List<MediaWrapper> mMediaList = new ArrayList<MediaWrapper>();
    private ArrayList<PlayCallback> mCallbacks = new ArrayList();
    private HandlerThread mTimeUpdateThread;
    private Handler mTimeUpdateHandler;
    private SimpleExoPlayer mPlayer;
    private boolean isInit = false;

    public void onCreate() {
        super.onCreate();
        this.initPlayer();
        this.mTimeUpdateThread = new HandlerThread("updateTime");
        this.mTimeUpdateThread.start();
        this.mTimeUpdateHandler = new Handler(this.mTimeUpdateThread.getLooper()){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                switch (msg.what) {
                    case 267: {
                        MediaEvent event = new MediaEvent(267);
                        AudioPlayerService.this.processCallback(event);
                        AudioPlayerService.this.mTimeUpdateHandler.sendEmptyMessageDelayed(267, SystemClock.currentThreadTimeMillis() + 300L);
                    }
                }
            }
        };
    }

    private void initPlayer() {
        this.mPlayer = ExoPlayerFactory.newSimpleInstance((Context)this);
    }

    public void onDestroy() {
        super.onDestroy();
        Log.d((String)"AudioPlayerService", (String)"onDestroy");
        if (this.mPlayer != null) {
            this.mPlayer.stop(true);
            this.mPlayer.release();
            this.mPlayer = null;
        }
        this.mTimeUpdateHandler.removeMessages(267);
    }

    @Override
    @MainThread
    public void loadMedia(MediaWrapper media) {
        ArrayList<MediaWrapper> arrayList = new ArrayList<MediaWrapper>();
        arrayList.add(media);
        this.loadMedia(arrayList, 0);
    }

    @Override
    @MainThread
    public synchronized void removeCallback(PlayCallback cb) {
        this.mCallbacks.remove(cb);
    }

    @Override
    @MainThread
    public void pause() {
        if (this.mPlayer != null) {
            this.mPlayer.setPlayWhenReady(false);
            this.processCallback(new MediaEvent(261));
        }
        this.mTimeUpdateHandler.removeMessages(267);
        this.mTimeUpdateHandler.sendEmptyMessage(267);
    }

    @Override
    @MainThread
    public void play() {
        if (this.mPlayer != null) {
            this.mPlayer.setPlayWhenReady(true);
            this.processCallback(new MediaEvent(260));
            this.mTimeUpdateHandler.removeMessages(267);
            this.mTimeUpdateHandler.sendEmptyMessage(267);
        }
    }

    @Override
    @MainThread
    public void seek(int position) {
        if (this.mPlayer != null) {
            this.mPlayer.seekTo((long)position);
        }
    }

    @Override
    public void setRate(float speed) {
        if (this.mPlayer != null) {
            PlaybackParameters playbackParameters = new PlaybackParameters(speed);
            this.mPlayer.setPlaybackParameters(playbackParameters);
        }
    }

    @Override
    public boolean isPlaying() {
        if (this.mPlayer != null) {
            return this.mPlayer.getPlayWhenReady();
        }
        return false;
    }

    @MainThread
    public void loadMedia(List<MediaWrapper> mediaList, int position) {
        this.mMediaList.clear();
        List<MediaWrapper> currentMediaList = this.mMediaList;
        for (int i = 0; i < mediaList.size(); ++i) {
            currentMediaList.add(mediaList.get(i));
        }
        if (this.mMediaList.size() == 0) {
            Log.w((String)"AudioPlayerService", (String)"Warning: empty media list, nothing to play !");
            return;
        }
        if (this.mMediaList.size() > position && position >= 0) {
            this.mCurrentIndex = position;
        } else {
            Log.w((String)"AudioPlayerService", (String)("Warning: positon " + position + " out of bounds"));
            this.mCurrentIndex = 0;
        }
        this.playIndex(this.mCurrentIndex);
    }

    @Override
    public boolean hasCurrentMedia() {
        return this.mCurrentIndex >= 0 && this.mCurrentIndex < this.mMediaList.size();
    }

    public void playIndex(int position) {
        MediaWrapper mw = this.mMediaList.get(position);
        if (mw == null) {
            return;
        }
        Log.d((String)"AudioPlayerService", (String)("playIndex: " + mw.getUri().toString()));
        try {
            DefaultDataSourceFactory dataSourceFactory = new DefaultDataSourceFactory((Context)this, Util.getUserAgent((Context)this, (String)this.getPackageName()));
            ProgressiveMediaSource mediaSource = new ProgressiveMediaSource.Factory((DataSource.Factory)dataSourceFactory).createMediaSource(mw.getUri());
            this.mPlayer.prepare((MediaSource)mediaSource, false, true);
            this.mPlayer.setPlayWhenReady(true);
            this.initMediaListener(mediaSource);
        }
        catch (Exception ie) {
            Log.e((String)"AudioPlayerService", (String)"playIndex: \u64ad\u653e\u5668\u521d\u59cb\u5316\u5931\u8d25");
        }
    }

    @Override
    @MainThread
    public synchronized void addCallback(PlayCallback cb) {
        if (!this.mCallbacks.contains(cb)) {
            this.mCallbacks.add(cb);
        }
    }

    private void initMediaListener(ProgressiveMediaSource mediaSource) {
        if (this.isInit) {
            return;
        }
        this.mPlayer.addListener(new Player.EventListener(){

            public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
                Log.d((String)"lzy12333", (String)("playWhenReady:" + playWhenReady + " ,onPlayerStateChanged: " + playbackState));
                if (playbackState != 1) {
                    if (playbackState == 2) {
                        if (AudioPlayerService.this.mPlayer.getBufferedPercentage() >= 100) {
                            return;
                        }
                        MediaEvent event = new MediaEvent(259);
                        AudioPlayerService.this.processCallback(event);
                    } else if (playWhenReady && playbackState == 3) {
                        AudioPlayerService.this.processCallback(new MediaEvent(260));
                        AudioPlayerService.this.mTimeUpdateHandler.removeMessages(267);
                        AudioPlayerService.this.mTimeUpdateHandler.sendEmptyMessage(267);
                    } else if (playWhenReady && playbackState == 4) {
                        AudioPlayerService.this.processCallback(new MediaEvent(265));
                    }
                }
            }

            public void onPlayerError(ExoPlaybackException error) {
                switch (error.type) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
            }
        });
        this.isInit = true;
    }

    private void processCallback(MediaEvent event) {
        for (PlayCallback callback : this.mCallbacks) {
            callback.onMediaPlayerEvent(event);
        }
    }

    @Override
    public long getTime() {
        return this.mPlayer == null ? 0L : this.mPlayer.getContentPosition();
    }

    @Override
    public long getLength() {
        return this.mPlayer == null ? 0L : this.mPlayer.getDuration();
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    public class LocalBinder
    extends Binder
    implements PlayServiceBinder {
        @Override
        public IPlayerService getService() {
            return AudioPlayerService.this;
        }
    }
}

