/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.service;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import androidx.annotation.MainThread;
import com.edusoho.videoplayer.service.IPlayerService;
import com.edusoho.videoplayer.service.PlayServiceBinder;

public class Client {
    public static final String TAG = "PlaybackService.Client";
    private boolean mBound = false;
    private final Callback mCallback;
    private final Context mContext;
    private Intent mServiceIntent;
    private final ServiceConnection mServiceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName name, IBinder iBinder) {
            if (!Client.this.mBound) {
                return;
            }
            PlayServiceBinder playServiceBinder = (PlayServiceBinder)iBinder;
            IPlayerService service = playServiceBinder.getService();
            if (service != null) {
                Client.this.mCallback.onConnected(service);
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            Client.this.mBound = false;
            Client.this.mCallback.onDisconnected();
        }
    };

    private void startService(Context context) {
        context.startService(this.mServiceIntent);
    }

    public Client(Context context, Callback callback, Intent serviceIntent) {
        if (context == null || callback == null) {
            throw new IllegalArgumentException("Context and callback can't be null");
        }
        this.mContext = context;
        this.mCallback = callback;
        this.mServiceIntent = serviceIntent;
    }

    @MainThread
    public void connect() {
        if (this.mBound) {
            return;
        }
        this.startService(this.mContext);
        this.mBound = this.mContext.bindService(this.mServiceIntent, this.mServiceConnection, 1);
    }

    @MainThread
    public void disconnect() {
        if (this.mBound) {
            this.mBound = false;
            this.mContext.unbindService(this.mServiceConnection);
        }
    }

    @MainThread
    public static interface Callback {
        public void onConnected(IPlayerService var1);

        public void onDisconnected();
    }
}

