/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.service;

import android.content.Context;
import android.content.Intent;
import androidx.annotation.MainThread;
import com.edusoho.videoplayer.service.Client;
import com.edusoho.videoplayer.service.IPlayerService;
import java.util.ArrayList;

public class Helper {
    private ArrayList<Client.Callback> mFragmentCallbacks = new ArrayList();
    private final Client.Callback mActivityCallback;
    private Client mClient;
    protected IPlayerService mService;
    private final Client.Callback mClientCallback = new Client.Callback(){

        @Override
        public void onConnected(IPlayerService service) {
            Helper.this.mService = service;
            Helper.this.mActivityCallback.onConnected(service);
            for (Client.Callback connectCb : Helper.this.mFragmentCallbacks) {
                connectCb.onConnected(Helper.this.mService);
            }
        }

        @Override
        public void onDisconnected() {
            Helper.this.mService = null;
            Helper.this.mActivityCallback.onDisconnected();
            for (Client.Callback connectCb : Helper.this.mFragmentCallbacks) {
                connectCb.onDisconnected();
            }
        }
    };

    public Helper(Context context, Client.Callback activityCallback, Intent serviceIntent) {
        this.mClient = new Client(context, this.mClientCallback, serviceIntent);
        this.mActivityCallback = activityCallback;
    }

    @MainThread
    public void registerFragment(Client.Callback connectCb) {
        if (connectCb == null) {
            throw new IllegalArgumentException("connectCb can't be null");
        }
        this.mFragmentCallbacks.add(connectCb);
        if (this.mService != null) {
            connectCb.onConnected(this.mService);
        }
    }

    @MainThread
    public void unregisterFragment(Client.Callback connectCb) {
        if (this.mService != null) {
            connectCb.onDisconnected();
        }
        this.mFragmentCallbacks.remove(connectCb);
    }

    @MainThread
    public void onStart() {
        this.mClient.connect();
    }

    @MainThread
    public void onStop() {
        this.mClientCallback.onDisconnected();
        this.mClient.disconnect();
    }
}

