/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.ui;

import android.os.Bundle;
import android.os.PowerManager;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;

public abstract class AbstractVideoPlayerFragment
extends Fragment {
    public static final String PLAY_URI = "play_uri";
    public static final String PLAY_POSITION = "play_position";
    protected PowerManager.WakeLock mWakeLock = null;
    private static final String POWER_LOCK = "VideoPlayerFragmentLock";
    private String mMediaUrl;
    private long mSeekPosition;

    private void initWakeLock() {
        PowerManager pm = (PowerManager)this.getContext().getSystemService("power");
        this.mWakeLock = pm.newWakeLock(536870938, POWER_LOCK);
        this.mWakeLock.setReferenceCounted(false);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.mMediaUrl = this.getArguments().getString(PLAY_URI);
            this.mSeekPosition = this.getArguments().getInt(PLAY_POSITION);
        }
        this.initWakeLock();
    }

    public void onResume() {
        super.onResume();
        if (null != this.mWakeLock && !this.mWakeLock.isHeld()) {
            this.mWakeLock.acquire();
        }
    }

    public void onStop() {
        super.onStop();
        if (this.mWakeLock != null) {
            try {
                this.mWakeLock.release();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void setMediaUrl(String mediaUrl) {
        this.mMediaUrl = mediaUrl;
    }

    protected void setSeekPosition(long seekPosition) {
        this.mSeekPosition = seekPosition;
    }

    protected String getMediaUrl() {
        return this.mMediaUrl;
    }

    protected long getSeekPosition() {
        return this.mSeekPosition;
    }

    public abstract void play();

    public abstract void pause();

    public abstract void playVideo(String var1);

    protected abstract void changeMediaSource(String var1);
}

