/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.Toast;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.edusoho.videoplayer.R;
import com.edusoho.videoplayer.helper.ControllerViewTouchHelper;
import com.edusoho.videoplayer.media.MediaWrapper;
import com.edusoho.videoplayer.service.AudioPlayerService;
import com.edusoho.videoplayer.service.Client;
import com.edusoho.videoplayer.service.Helper;
import com.edusoho.videoplayer.service.IPlayerService;
import com.edusoho.videoplayer.service.listener.PlayCallback;
import com.edusoho.videoplayer.util.MediaEvent;
import com.edusoho.videoplayer.view.VideoControllerView;

public class AudioPlayerFragment
extends Fragment
implements Client.Callback,
PlayCallback,
VideoControllerView.ControllerListener {
    public static final String PLAY_URI = "play_uri";
    public static final String TAG = "AudioPlayerFragment";
    private Helper mHelper;
    protected IPlayerService mService;
    protected VideoControllerView mVideoControllerView;
    private ProgressBar mProgressView;
    private FrameLayout mContainerView;
    private String mPlayUrl;
    private static final int START_PLAYBACK = 4;
    private static final int PROGRESS_CHANGE = 2;
    private static final int PLAY_STATUS_CHANGE = 3;
    private static final int PROGRESS_BUFFERING = 5;
    private static final int PROGRESS_COMPLETE = 6;
    private static final int PLAYER_PREPARE = 7;
    private static final int STOP_PLAYBACK = 7;
    private final Handler mHandler = new Handler(Looper.getMainLooper(), new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            if (AudioPlayerFragment.this.mService == null) {
                return true;
            }
            switch (msg.what) {
                case 7: {
                    AudioPlayerFragment.this.preparePlayerController();
                    break;
                }
                case 5: {
                    AudioPlayerFragment.this.updateProcessBarStatus(0);
                    break;
                }
                case 6: {
                    AudioPlayerFragment.this.updateProcessBarStatus(4);
                    break;
                }
                case 2: {
                    AudioPlayerFragment.this.updateMediaProgress();
                    break;
                }
                case 3: {
                    AudioPlayerFragment.this.updateMediaPlayStatus(AudioPlayerFragment.this.mService.isPlaying());
                    break;
                }
                case 4: {
                    AudioPlayerFragment.this.startPlayback();
                }
            }
            return true;
        }
    });

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mHelper = new Helper(this.getContext(), this, this.getServiceIntent());
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.mPlayUrl = bundle.getString(PLAY_URI);
        }
        this.mHelper.onStart();
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mProgressView = (ProgressBar)view.findViewById(R.id.pb_player_progress);
        this.mContainerView = (FrameLayout)view.findViewById(R.id.fl_player_contaner);
        this.mVideoControllerView = (VideoControllerView)view.findViewById(R.id.vc_player_controller);
        this.mVideoControllerView.setControllerListener(this);
        this.mVideoControllerView.showControllerBar(true);
    }

    protected void setContainerView(View containerView) {
        this.mContainerView.removeAllViews();
        this.mContainerView.addView(containerView);
    }

    protected void setContainerView(View containerView, ViewGroup.LayoutParams lp) {
        this.mContainerView.removeAllViews();
        if (lp == null) {
            lp = new ViewGroup.LayoutParams(-2, -2);
        }
        this.mContainerView.addView(containerView, lp);
    }

    private Intent getServiceIntent() {
        return new Intent(this.getContext(), AudioPlayerService.class);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mService != null) {
            this.mService.removeCallback(this);
        }
    }

    public void destoryService() {
        if (this.mService != null) {
            this.mService.pause();
        }
        this.mHelper.onStop();
        this.getContext().stopService(this.getServiceIntent());
    }

    @Override
    public void onConnected(IPlayerService service) {
        this.mService = service;
        this.mHandler.sendEmptyMessage(4);
    }

    @Override
    public void onDisconnected() {
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View contentView = inflater.inflate(R.layout.content_audio_layout, null);
        ViewGroup parent = (ViewGroup)contentView.getParent();
        if (parent != null) {
            parent.removeView(contentView);
        }
        return contentView;
    }

    @MainThread
    private void updateMediaProgress() {
        this.mVideoControllerView.updateMediaProgress((int)this.mService.getTime(), (int)this.mService.getLength());
    }

    @MainThread
    protected void updateMediaPlayStatus(boolean isPlay) {
        this.mVideoControllerView.updatePlayStatus(isPlay);
    }

    @MainThread
    private void updateProcessBarStatus(int visibility) {
        if (visibility == this.mProgressView.getVisibility()) {
            return;
        }
        this.mProgressView.setVisibility(visibility);
    }

    @Override
    public void onSeek(int position) {
        this.mService.seek(position);
    }

    @Override
    public void onChangeScreen(int orientation) {
    }

    @Override
    public void onPlayStatusChange(boolean isPlay) {
        if (this.mService != null) {
            if (isPlay) {
                if (this.mService.isPlaying()) {
                    return;
                }
                this.mService.play();
            } else {
                this.mService.pause();
            }
        }
    }

    @Override
    public void onChangeRate(float rate) {
    }

    @Override
    public void onChangePlaySource(String url) {
    }

    @Override
    public void onChangeOverlay(boolean isShow) {
    }

    @Override
    public void onMediaEvent(MediaEvent event) {
    }

    @Override
    public void onMediaPlayerEvent(MediaEvent event) {
        switch (event.type) {
            case 260: {
                this.mHandler.sendEmptyMessage(6);
                this.mHandler.sendEmptyMessage(7);
                this.mHandler.sendEmptyMessage(3);
                break;
            }
            case 267: {
                this.mHandler.sendEmptyMessage(6);
                this.mHandler.sendEmptyMessage(2);
                break;
            }
            case 259: {
                this.mHandler.sendEmptyMessage(5);
                break;
            }
            case 262: {
                Log.d((String)"flag--", (String)"onMediaPlayerEvent: Event.Stopped");
                break;
            }
            case 265: {
                this.stopPlayback();
            }
        }
    }

    private void preparePlayerController() {
        if (this.getActivity() == null) {
            return;
        }
        ControllerViewTouchHelper touchHelper = new ControllerViewTouchHelper((Activity)this.getActivity());
        touchHelper.updateVideoSize(this.getView().getWidth(), this.getView().getHeight());
        this.mVideoControllerView.setControllerViewTouchHelper(touchHelper);
    }

    protected void playAudio(String uri) {
        if (TextUtils.isEmpty((CharSequence)uri)) {
            Toast.makeText((Context)this.getContext(), (int)R.string.audio_no_url, (int)0).show();
            return;
        }
        this.mPlayUrl = uri;
        this.startPlayback();
    }

    protected void stopPlayback() {
        this.mService.seek(0);
        this.mVideoControllerView.updatePlayStatus(false);
    }

    @MainThread
    protected void startPlayback() {
        if (TextUtils.isEmpty((CharSequence)this.mPlayUrl) || this.mService == null) {
            return;
        }
        this.mService.addCallback(this);
        if (this.mService.hasCurrentMedia()) {
            this.mService.play();
            return;
        }
        this.mService.loadMedia(new MediaWrapper(Uri.parse((String)this.mPlayUrl)));
    }

    public int getPlayLastPosition() {
        return this.mVideoControllerView.getNaturalSeekProgress();
    }

    public void setPlayLastPosition(int position) {
        this.mVideoControllerView.setNaturalMediaPosition(position);
    }

    public void setSeekToDropForwardEnable(boolean enable) {
        this.mVideoControllerView.setSeekToDropForwardEnable(enable);
    }
}

