/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.ui;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ProgressBar;
import androidx.annotation.Nullable;
import com.edusoho.videoplayer.R;
import com.edusoho.videoplayer.ui.AbstractVideoPlayerFragment;
import com.edusoho.videoplayer.view.VideoControllerView;
import com.edusoho.videoplayer.view.VideoPlayerHeaderView;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.ui.SimpleExoPlayerView;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;

public class ExoPlayerFragment
extends AbstractVideoPlayerFragment
implements Player.EventListener {
    private static final String TAG = "VideoPlayerFragment";
    private static final DefaultBandwidthMeter BANDWIDTH_METER = new DefaultBandwidthMeter();
    private VideoControllerView mVideoControllerView;
    private VideoPlayerHeaderView mVideoPlayerHeaderView;
    private ProgressBar mProgressView;
    private Handler mainHandler;
    private SimpleExoPlayerView mExoPlayerView;
    private SimpleExoPlayer player;
    protected VideoControllerView.ControllerListener mControllerListener = new VideoControllerView.ControllerListener(){

        @Override
        public void onSeek(int position) {
            ExoPlayerFragment.this.player.seekTo((long)position);
        }

        @Override
        public void onChangeScreen(int orientation) {
            ExoPlayerFragment.this.changeHeaderViewStatus(orientation == 2);
            ExoPlayerFragment.this.changeScreenLayout(orientation);
        }

        @Override
        public void onPlayStatusChange(boolean isPlay) {
            Log.d((String)ExoPlayerFragment.TAG, (String)("onPlayStatusChange:" + isPlay));
            if (isPlay) {
                ExoPlayerFragment.this.play();
            } else {
                ExoPlayerFragment.this.pause();
            }
        }

        @Override
        public void onChangeRate(float rate) {
        }

        @Override
        public void onChangePlaySource(String url) {
            ExoPlayerFragment.this.changeMediaSource(url);
        }

        @Override
        public void onChangeOverlay(boolean isShow) {
            ExoPlayerFragment.this.changeHeaderViewStatus(isShow);
        }
    };

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View contentView = inflater.inflate(R.layout.exo_content_video_layout, null);
        ViewGroup parent = (ViewGroup)contentView.getParent();
        if (parent != null) {
            parent.removeView(contentView);
        }
        return contentView;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mExoPlayerView = (SimpleExoPlayerView)view.findViewById(R.id.player_view);
        this.mExoPlayerView.requestFocus();
        this.mVideoControllerView = (VideoControllerView)view.findViewById(R.id.vc_player_controller);
        this.mProgressView = (ProgressBar)view.findViewById(R.id.pb_player_progress);
        this.getActivity().setVolumeControlStream(3);
        this.mVideoControllerView.setControllerListener(this.mControllerListener);
        this.mainHandler = new Handler();
    }

    protected void changeScreenLayout(int orientation) {
        if (orientation == this.getResources().getConfiguration().orientation) {
            return;
        }
        View playView = this.getView();
        ViewParent viewParent = playView.getParent();
        if (viewParent == null) {
            return;
        }
        ViewGroup parent = (ViewGroup)viewParent;
        ViewGroup.LayoutParams lp = parent.getLayoutParams();
        lp.height = orientation == 2 ? -1 : this.getContext().getResources().getDimensionPixelOffset(R.dimen.video_height);
        lp.width = -1;
        parent.setLayoutParams(lp);
        int requestedOrientarion = orientation == 2 ? 0 : 1;
        this.getActivity().setRequestedOrientation(requestedOrientarion);
    }

    protected void changeHeaderViewStatus(boolean isShow) {
        int visibility;
        if (this.mVideoPlayerHeaderView == null) {
            return;
        }
        int n = visibility = isShow ? 0 : 4;
        if (this.getResources().getConfiguration().orientation == 1) {
            visibility = 4;
        }
        this.mVideoPlayerHeaderView.setVisibility(visibility);
    }

    @Override
    public void play() {
    }

    @Override
    public void playVideo(String videoUri) {
    }

    @Override
    public void pause() {
    }

    public void onStart() {
        super.onStart();
        this.startPlayback();
    }

    private void startPlayback() {
        if (this.player == null) {
            this.player = this.initializePlayer();
        }
        this.mExoPlayerView.setPlayer((Player)this.player);
        this.player.addListener((Player.EventListener)this);
    }

    private SimpleExoPlayer initializePlayer() {
        AdaptiveTrackSelection.Factory videoTrackSelectionFactory = new AdaptiveTrackSelection.Factory((BandwidthMeter)BANDWIDTH_METER);
        DefaultTrackSelector trackSelector = new DefaultTrackSelector((TrackSelection.Factory)videoTrackSelectionFactory);
        SimpleExoPlayer player = ExoPlayerFactory.newSimpleInstance((Context)this.getContext(), (TrackSelector)trackSelector, (LoadControl)new DefaultLoadControl());
        player.setPlayWhenReady(true);
        player.addListener((Player.EventListener)this);
        return player;
    }

    private DefaultDataSourceFactory getDataSourceFactory() {
        return new DefaultDataSourceFactory(this.getContext(), "android-player");
    }

    @Override
    protected void changeMediaSource(String url) {
    }

    public void onLoadingChanged(boolean isLoading) {
        Log.d((String)TAG, (String)("isLoading:" + isLoading));
    }

    public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
        Log.d((String)TAG, (String)("playWhenReady:" + playWhenReady));
    }

    public void onPlayerError(ExoPlaybackException error) {
        Log.d((String)TAG, (String)("error:" + error));
    }

    public void onTimelineChanged(Timeline timeline, @Nullable Object manifest, int reason) {
    }

    public void onRepeatModeChanged(int repeatMode) {
    }

    public void onShuffleModeEnabledChanged(boolean shuffleModeEnabled) {
    }

    public void onPositionDiscontinuity(int reason) {
    }

    public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
    }

    public void onSeekProcessed() {
    }

    public void onTracksChanged(TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
    }

    private void releasePlayer() {
        if (this.player != null) {
            this.player.release();
            this.player = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.releasePlayer();
    }
}

