/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.ui;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.PowerManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.edusoho.videoplayer.R;
import com.edusoho.videoplayer.broadcast.MessageBroadcastReceiver;
import com.edusoho.videoplayer.media.ILogoutListener;
import com.edusoho.videoplayer.media.IPlayerStateListener;
import com.edusoho.videoplayer.media.IVideoPlayer;
import com.edusoho.videoplayer.media.M3U8Stream;
import com.edusoho.videoplayer.media.VideoPlayerFactory;
import com.edusoho.videoplayer.media.listener.SimpleVideoControllerListener;
import com.edusoho.videoplayer.util.FileUtils;
import com.edusoho.videoplayer.util.M3U8Util;
import com.edusoho.videoplayer.view.VideoControllerView;
import com.edusoho.videoplayer.view.VideoPlayerHeaderView;
import java.util.List;

public class VideoPlayerFragment
extends Fragment
implements MessageBroadcastReceiver.Callback,
IPlayerStateListener {
    public static final String PLAY_URI = "play_uri";
    public static final String SUBTITLE_URI = "subtitle_uri";
    public static final String SUBTITLE_DELAY_TIME = "subtitle_delay_time";
    public static final String PLAY_MEDIA_CODER = "play_media_coder";
    public static final String PLAY_MEDIA_PLAYER_TYPE = "play_media_player_type";
    public static final String PLAY_DIGEST_KET = "play_digest_key";
    private static final String TAG = "VideoPlayerFragment";
    private static final String VERSION = "1.4.8";
    private static final String POWER_LOCK = "VideoPlayerFragmentLock";
    protected PowerManager.WakeLock mWakeLock = null;
    private ILogoutListener mLogoutListener;
    private VideoControllerView mVideoControllerView;
    private VideoPlayerHeaderView mVideoPlayerHeaderView;
    protected VideoPlayerHeaderView.HeaderEventListener mHeaderEventListener = new VideoPlayerHeaderView.HeaderEventListener(){

        @Override
        public void onBack() {
            VideoPlayerFragment.this.changeHeaderViewStatus(false);
            VideoPlayerFragment.this.changeScreenLayout(1);
        }
    };
    private MessageBroadcastReceiver mMessageBroadcastReceiver;
    private String mMediaUrl;
    private List<Uri> mSubtitleUris;
    private Uri mPlayUri;
    private int mMediaCoder;
    private int mMediaPlayerType;
    private ViewGroup mPlayContainer;
    private View mAudioCover;
    private boolean hasRegistedMessageReceiver;
    private Object messageReceiverLock = new Object();
    private IVideoPlayer mVideoPlayer;
    private AsyncTask<String, String, String> mDownloadTask;
    private boolean isAudioOn;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getActivity().getWindow().setFlags(0x1000000, 0x1000000);
        if (this.getArguments() != null) {
            this.mMediaCoder = this.getArguments().getInt(PLAY_MEDIA_CODER, 0);
            this.mMediaPlayerType = this.getArguments().getInt(PLAY_MEDIA_PLAYER_TYPE, 2);
            this.mMediaUrl = this.getArguments().getString(PLAY_URI);
            this.mSubtitleUris = (List)((Object)this.getArguments().getSerializable(SUBTITLE_URI));
        }
        if (!TextUtils.isEmpty((CharSequence)this.mMediaUrl)) {
            this.mPlayUri = Uri.parse((String)this.mMediaUrl);
        }
        this.initWakeLock();
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View contentView = inflater.inflate(R.layout.content_video_layout, null);
        ViewGroup parent = (ViewGroup)contentView.getParent();
        if (parent != null) {
            parent.removeView(contentView);
        }
        return contentView;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mPlayContainer = (ViewGroup)view.findViewById(R.id.fl_player_contaner);
        if (this.getActivity().isFinishing() || this.isDetached()) {
            return;
        }
        this.getActivity().setVolumeControlStream(3);
        this.mVideoControllerView = (VideoControllerView)view.findViewById(R.id.vc_player_controller);
        this.createVideoPlayer(this.mMediaPlayerType, new VideoPlayerGetCallback(){

            @Override
            public void success() {
                if (VideoPlayerFragment.this.mPlayUri != null) {
                    VideoPlayerFragment.this.mVideoPlayer.setSubtitlesUrls(VideoPlayerFragment.this.mSubtitleUris);
                    VideoPlayerFragment.this.parseMediaWrapper(VideoPlayerFragment.this.mPlayUri);
                }
            }
        });
        if (this.mLogoutListener != null) {
            this.mVideoPlayer.addLogListener(this.mLogoutListener);
        }
        this.mVideoControllerView.showControllerBar(true);
    }

    public void onResume() {
        super.onResume();
        if (this.mVideoPlayer != null && !this.isAudioOn) {
            this.mVideoPlayer.onStart();
        }
        if (null != this.mWakeLock && !this.mWakeLock.isHeld()) {
            this.mWakeLock.acquire();
        }
        this.registMessageReceiver();
    }

    public void onPause() {
        super.onPause();
        if (this.mVideoPlayer != null) {
            this.savePosition(this.mVideoPlayer.getPosition());
            if (!this.isAudioOn) {
                this.mVideoPlayer.pause();
            }
        }
    }

    public void onStop() {
        super.onStop();
        if (this.mWakeLock != null) {
            try {
                this.mWakeLock.release();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.unRegistMessageReceiver();
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.mDownloadTask != null) {
            this.mDownloadTask.cancel(true);
            this.mDownloadTask = null;
            Log.d((String)TAG, (String)"cancel task");
        }
        if (this.mVideoPlayer != null) {
            this.mVideoPlayer.onStop();
        }
        Log.d((String)TAG, (String)"onDestroyView");
    }

    private void checkLibExists(VideoPlayerGetCallback callback) {
        if (callback != null) {
            callback.success();
        }
    }

    private void initWakeLock() {
        PowerManager pm = (PowerManager)this.getContext().getSystemService("power");
        this.mWakeLock = pm.newWakeLock(536870938, POWER_LOCK);
        this.mWakeLock.setReferenceCounted(false);
    }

    private void createVideoPlayer(int mediaPlayerType, VideoPlayerGetCallback videoPlayerGetCallback) {
        if (this.mVideoPlayer != null) {
            this.mPlayContainer.removeView(this.mVideoPlayer.getView());
            this.mVideoPlayer.onStop();
            this.mVideoPlayer = null;
        }
        this.mVideoPlayer = this.getVideoPlayer(mediaPlayerType);
        this.mVideoPlayer.setDigestKey(this.getArguments().getString(PLAY_DIGEST_KET, ""));
        this.mPlayContainer.addView(this.mVideoPlayer.getView());
        this.mVideoControllerView.clearControllerListener();
        this.addVideoControllerListener(this.getDefaultControllerListener());
        if (this.mAudioCover != null) {
            if (this.isAudioOn) {
                this.mAudioCover.setVisibility(0);
                this.mVideoControllerView.setScreenChangeVisible(8);
            } else {
                this.mAudioCover.setVisibility(8);
                this.mVideoControllerView.setScreenChangeVisible(0);
            }
            this.mPlayContainer.addView(this.mAudioCover);
        }
        this.mVideoControllerView.bringToFront();
        this.mVideoPlayer.addVideoController(this.mVideoControllerView);
        this.checkLibExists(videoPlayerGetCallback);
    }

    protected void setCached(boolean cached) {
        if (this.mVideoControllerView != null) {
            this.mVideoControllerView.setCached(cached);
        }
    }

    protected void setAudioOn(boolean isAudioOn) {
        this.isAudioOn = isAudioOn;
    }

    protected void setAudioCover(View view) {
        this.mAudioCover = view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registMessageReceiver() {
        Object object = this.messageReceiverLock;
        synchronized (object) {
            if (this.hasRegistedMessageReceiver) {
                return;
            }
        }
        this.mMessageBroadcastReceiver = new MessageBroadcastReceiver(this);
        this.getContext().registerReceiver((BroadcastReceiver)this.mMessageBroadcastReceiver, new IntentFilter("com.edusoho.videoplayer.message"));
        this.hasRegistedMessageReceiver = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unRegistMessageReceiver() {
        Object object = this.messageReceiverLock;
        synchronized (object) {
            if (!this.hasRegistedMessageReceiver) {
                return;
            }
        }
        if (this.mMessageBroadcastReceiver != null) {
            this.getContext().unregisterReceiver((BroadcastReceiver)this.mMessageBroadcastReceiver);
            this.mMessageBroadcastReceiver = null;
            this.hasRegistedMessageReceiver = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IVideoPlayer getVideoPlayer(int mediaPlayerType) {
        if (this.mVideoPlayer != null) {
            return this.mVideoPlayer;
        }
        VideoPlayerFragment videoPlayerFragment = this;
        synchronized (videoPlayerFragment) {
            if (this.mVideoPlayer == null) {
                this.mVideoPlayer = VideoPlayerFactory.getInstance().createPlayer(this.getContext(), this.mMediaCoder, mediaPlayerType);
            }
        }
        return this.mVideoPlayer;
    }

    protected void setSeekPosition(long position) {
        this.mVideoPlayer.setSeekPosition(position);
    }

    protected void savePosition(long seekTime) {
    }

    protected void setVideoSize(int w, int h) {
        ViewGroup.LayoutParams lp = this.getView().getLayoutParams();
        lp.height = h;
        lp.width = w;
        this.getView().setLayoutParams(lp);
    }

    public void addVideoControllerListener(VideoControllerView.ControllerListener listener) {
        this.mVideoControllerView.setControllerListener(listener);
    }

    public int getPlayLastPosition() {
        return this.mVideoControllerView.getNaturalSeekProgress();
    }

    public void setMaxLearnPosition(int position) {
        Log.d((String)TAG, (String)("setMaxLearnPosition:" + position));
        this.mVideoControllerView.setNaturalMediaPosition(position);
    }

    public void setSeekToDropForwardEnable(boolean enable) {
        this.mVideoControllerView.setSeekToDropForwardEnable(enable);
    }

    public void setSeekEnable(boolean enable) {
        this.mVideoControllerView.setSeekEnable(enable);
    }

    protected void setVideoPlayerHeaderView(VideoPlayerHeaderView headerView) {
        this.mVideoPlayerHeaderView = headerView;
        ViewGroup rootView = (ViewGroup)this.getView();
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -2);
        lp.gravity = 48;
        rootView.addView((View)headerView, (ViewGroup.LayoutParams)lp);
        this.mVideoPlayerHeaderView.setHeaderEventListener(this.mHeaderEventListener);
    }

    protected VideoControllerView.ControllerListener getDefaultControllerListener() {
        return new SimpleVideoControllerListener(){

            @Override
            public void onChangeScreen(int orientation) {
                super.onChangeScreen(orientation);
                VideoPlayerFragment.this.changeHeaderViewStatus(orientation == 2);
                VideoPlayerFragment.this.changeScreenLayout(orientation);
            }

            @Override
            public void onChangeOverlay(boolean isShow) {
                super.onChangeOverlay(isShow);
                VideoPlayerFragment.this.changeHeaderViewStatus(isShow);
            }

            @Override
            public void onChangePlaySource(String url) {
                super.onChangePlaySource(url);
            }

            @Override
            public void mediaProgressChanging(int position) {
                super.mediaProgressChanging(position);
                VideoPlayerFragment.this.mediaProgressUpdating(position);
            }
        };
    }

    protected void mediaProgressUpdating(int position) {
    }

    protected void changeHeaderViewStatus(boolean isShow) {
        if (this.mVideoPlayerHeaderView == null) {
            return;
        }
        int visibility = isShow ? 0 : 4;
        Log.d((String)TAG, (String)("changeHeaderViewStatus:" + this.getResources().getConfiguration().orientation));
        if (this.getResources().getConfiguration().orientation == 1) {
            visibility = 4;
        }
        this.mVideoPlayerHeaderView.setVisibility(visibility);
    }

    protected void changeScreenLayout(int orientation) {
        if (orientation == this.getResources().getConfiguration().orientation) {
            return;
        }
        View playView = this.getView();
        ViewParent viewParent = playView.getParent();
        if (viewParent == null) {
            return;
        }
        ViewGroup parent = (ViewGroup)viewParent;
        ViewGroup.LayoutParams lp = parent.getLayoutParams();
        lp.height = orientation == 2 ? -1 : this.getContext().getResources().getDimensionPixelOffset(R.dimen.video_height);
        lp.width = -1;
        parent.setLayoutParams(lp);
        int requestedOrientarion = orientation == 2 ? 0 : 1;
        this.getActivity().setRequestedOrientation(requestedOrientarion);
    }

    private void exit(int resultCode) {
        if (this.getActivity().isFinishing()) {
            return;
        }
        this.getActivity().finish();
    }

    public synchronized void playVideo(String videoUri) {
        this.mMediaUrl = videoUri;
        this.mPlayUri = Uri.parse((String)this.mMediaUrl);
        if (this.mVideoPlayer != null) {
            this.parseMediaWrapper(this.mPlayUri);
        }
    }

    public synchronized void playVideo(String videoUri, List<Uri> subtitles) {
        this.mMediaUrl = videoUri;
        this.mPlayUri = Uri.parse((String)this.mMediaUrl);
        if (this.mVideoPlayer != null) {
            this.mVideoPlayer.setSubtitlesUrls(subtitles);
            this.parseMediaWrapper(this.mPlayUri);
        }
    }

    private void startPlayback() {
        if (this.getActivity() == null || this.getContext() == null || this.getActivity().isFinishing()) {
            return;
        }
        this.mVideoPlayer.start();
    }

    private void parseMediaWrapper(final Uri uri) {
        if (TextUtils.isEmpty((CharSequence)uri.getPath()) || "file".equals(uri.getScheme()) || !uri.getPath().endsWith(".m3u8")) {
            this.playWithMedia(uri.toString());
            return;
        }
        if (this.mDownloadTask != null) {
            this.mDownloadTask.cancel(true);
            this.mDownloadTask = null;
        }
        this.mDownloadTask = new AsyncTask<String, String, String>(){

            protected String doInBackground(String ... params) {
                if (VideoPlayerFragment.this.isDetached() || this.isCancelled() || VideoPlayerFragment.this.getContext() == null) {
                    return null;
                }
                return M3U8Util.downloadM3U8File(VideoPlayerFragment.this.getContext(), params[0].toString());
            }

            protected void onPostExecute(String url) {
                if (TextUtils.isEmpty((CharSequence)url)) {
                    return;
                }
                List<M3U8Stream> m3U8StreamList = M3U8Util.getM3U8StreamListFromPath(FileUtils.getParent(VideoPlayerFragment.this.mPlayUri.toString()), url);
                if (m3U8StreamList == null || m3U8StreamList.isEmpty()) {
                    VideoPlayerFragment.this.playWithMedia(uri.toString());
                    return;
                }
                VideoPlayerFragment.this.mVideoControllerView.setM3U8StreamList(m3U8StreamList);
                String playUri = VideoPlayerFragment.this.mVideoControllerView.getCurrentM3U8Stream() == null ? m3U8StreamList.get(0).getUrl() : VideoPlayerFragment.this.mVideoControllerView.getCurrentM3U8Stream().getUrl();
                VideoPlayerFragment.this.playWithMedia(playUri);
            }
        };
        this.mDownloadTask.execute((Object[])new String[]{uri.toString()});
    }

    private void playWithMedia(String mediaUrl) {
        this.mVideoPlayer.setMediaSource(mediaUrl);
        this.mVideoPlayer.addPlayerStateListener(this);
    }

    @Override
    public void onPrepare() {
        this.startPlayback();
        if (this.mVideoControllerView != null) {
            this.mVideoControllerView.setVisibility(0);
            this.mVideoControllerView.setScreenChangeVisible(this.isAudioOn ? 8 : 0);
        }
    }

    @Override
    public void onFinish() {
    }

    @Override
    public void onPlaying() {
    }

    public void play() {
        if (this.mVideoPlayer != null) {
            this.mVideoPlayer.play();
        }
    }

    public void pause() {
        if (this.mVideoPlayer != null) {
            this.mVideoPlayer.pause();
        }
    }

    public void setRate(float speed) {
        if (this.mVideoPlayer != null) {
            this.mVideoPlayer.setRate(speed);
        }
    }

    protected long getVideoLength() {
        return this.mVideoPlayer.getVideoLength();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mVideoControllerView.updateControllerConfiguration(newConfig.orientation);
    }

    public void stop() {
        if (this.mVideoPlayer != null) {
            this.mVideoPlayer.pause();
        }
    }

    @Override
    public void onReceive(String type, String mesasge) {
        if ("VideoFileNotFound".equals(type)) {
            Toast.makeText((Context)this.getContext(), (CharSequence)"\u6587\u4ef6\u672a\u53d1\u73b0", (int)0).show();
        } else if ("MediaCodecError".equals(type)) {
            Toast.makeText((Context)this.getContext(), (CharSequence)"\u64ad\u653e\u53d1\u751f\u9519\u8bef", (int)0).show();
        }
    }

    public void addLogoutListener(ILogoutListener logoutListener) {
        this.mLogoutListener = logoutListener;
        if (this.mVideoPlayer != null) {
            this.mVideoPlayer.addLogListener(logoutListener);
        }
    }

    public long getCurrentPosition() {
        if (this.mVideoPlayer != null) {
            return this.mVideoPlayer.getPosition();
        }
        return 0L;
    }

    static interface VideoPlayerGetCallback {
        public void success();
    }
}

