/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.ui.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.edusoho.videoplayer.R;
import com.edusoho.videoplayer.media.M3U8Stream;
import com.edusoho.videoplayer.ui.adapter.OnItemClickListener;
import java.util.List;

public class StreamListAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<M3U8Stream> m3U8Streams;
    private Context mContext;
    private OnItemClickListener mOnItemClickListener;

    public StreamListAdapter(Context context, List<M3U8Stream> m3U8Streams) {
        this.mContext = context;
        this.m3U8Streams = m3U8Streams;
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    public void onBindViewHolder(final ViewHolder holder, int position) {
        holder.setTitle(this.m3U8Streams.get(position).getKey());
        if (this.mOnItemClickListener != null) {
            holder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    StreamListAdapter.this.mOnItemClickListener.onItemClick(holder.getAdapterPosition());
                }
            });
        }
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ViewHolder((View)this.createTitleView());
    }

    private TextView createTitleView() {
        TextView textView = new TextView(this.mContext);
        textView.setTextColor(this.mContext.getResources().getColor(R.color.textIcons));
        int padding = this.mContext.getResources().getDimensionPixelSize(R.dimen.caption);
        textView.setWidth(this.mContext.getResources().getDimensionPixelSize(R.dimen.stream_btn_w));
        textView.setHeight(this.mContext.getResources().getDimensionPixelSize(R.dimen.stream_btn_h));
        textView.setTextSize(0, (float)padding);
        textView.setGravity(17);
        textView.setBackgroundResource(R.drawable.white_shape_rectangle_bg);
        return textView;
    }

    public int getItemCount() {
        return this.m3U8Streams.size();
    }

    protected class ViewHolder
    extends RecyclerView.ViewHolder {
        private TextView mTitleView;

        public ViewHolder(View view) {
            super(view);
            this.mTitleView = (TextView)view;
        }

        public void setTitle(String title) {
            this.mTitleView.setText((CharSequence)title);
        }
    }
}

