/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.view.InputDevice;
import android.view.MotionEvent;
import com.edusoho.videoplayer.util.AndroidUtil;
import com.edusoho.videoplayer.util.FileUtils;
import com.edusoho.videoplayer.util.Strings;
import com.edusoho.videoplayer.util.Util;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;

public class AndroidDevices {
    public static final String TAG = "VLC/UiTools/AndroidDevices";
    public static final String EXTERNAL_PUBLIC_DIRECTORY = Environment.getExternalStorageDirectory().getPath();
    static final boolean hasNavBar;
    static final boolean showInternalStorage;

    public static boolean hasExternalStorage() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static boolean hasNavBar() {
        return hasNavBar;
    }

    public static boolean hasCombBar(Context context) {
        return !AndroidDevices.isPhone(context) && Build.VERSION.SDK_INT >= 11 && Build.VERSION.SDK_INT <= 16;
    }

    public static boolean isPhone(Context context) {
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        return manager.getPhoneType() != 0;
    }

    public static boolean showInternalStorage() {
        return showInternalStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static ArrayList<String> getStorageDirectories() {
        BufferedReader bufReader = null;
        ArrayList<String> list = new ArrayList<String>();
        list.add(EXTERNAL_PUBLIC_DIRECTORY);
        List<String> typeWL = Arrays.asList("vfat", "exfat", "sdcardfs", "fuse", "ntfs", "fat32", "ext3", "ext4", "esdfs");
        List<String> typeBL = Arrays.asList("tmpfs");
        String[] mountWL = new String[]{"/mnt", "/Removable", "/storage"};
        String[] mountBL = new String[]{"/mnt/secure", "/mnt/shell", "/mnt/asec", "/mnt/obb", "/mnt/media_rw/extSdCard", "/mnt/media_rw/sdcard", "/storage/emulated"};
        String[] deviceWL = new String[]{"/dev/block/vold", "/dev/fuse", "/mnt/media_rw"};
        try {
            String line;
            bufReader = new BufferedReader(new FileReader("/proc/mounts"));
            while ((line = bufReader.readLine()) != null) {
                StringTokenizer tokens = new StringTokenizer(line, " ");
                String device = tokens.nextToken();
                String mountpoint = tokens.nextToken();
                String type = tokens.nextToken();
                if (list.contains(mountpoint) || typeBL.contains(type) || Strings.startsWith(mountBL, mountpoint) || !Strings.startsWith(deviceWL, device) || !typeWL.contains(type) && !Strings.startsWith(mountWL, mountpoint)) continue;
                int position = Strings.containsName(list, FileUtils.getFileNameFromPath(mountpoint));
                if (position > -1) {
                    list.remove(position);
                }
                list.add(mountpoint);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Util.close(bufReader);
        }
        catch (IOException iOException) {
            Util.close(bufReader);
            {
                catch (Throwable throwable) {
                    Util.close(bufReader);
                    throw throwable;
                }
            }
        }
        Util.close(bufReader);
        return list;
    }

    @TargetApi(value=12)
    public static float getCenteredAxis(MotionEvent event, InputDevice device, int axis) {
        InputDevice.MotionRange range = device.getMotionRange(axis, event.getSource());
        if (range != null) {
            float flat = range.getFlat();
            float value = event.getAxisValue(axis);
            if (Math.abs(value) > flat) {
                return value;
            }
        }
        return 0.0f;
    }

    public static boolean hasPlayServices(Context context) {
        try {
            context.getPackageManager().getPackageInfo("com.google.android.gsf", 4);
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    public static boolean hasLANConnection(Context context) {
        NetworkInfo networkInfo;
        boolean networkEnabled = false;
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivity != null && (networkInfo = connectivity.getActiveNetworkInfo()) != null && networkInfo.isConnected() && networkInfo.getType() != 0) {
            networkEnabled = true;
        }
        return networkEnabled;
    }

    public static boolean hasConnection(Context context) {
        NetworkInfo networkInfo;
        boolean networkEnabled = false;
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivity != null && (networkInfo = connectivity.getActiveNetworkInfo()) != null && networkInfo.isConnected()) {
            networkEnabled = true;
        }
        return networkEnabled;
    }

    public static boolean hasMobileConnection(Context context) {
        NetworkInfo networkInfo;
        boolean networkEnabled = false;
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivity != null && (networkInfo = connectivity.getActiveNetworkInfo()) != null && networkInfo.isConnected() && networkInfo.getType() == 0) {
            networkEnabled = true;
        }
        return networkEnabled;
    }

    static {
        HashSet<String> devicesWithoutNavBar = new HashSet<String>();
        devicesWithoutNavBar.add("HTC One V");
        devicesWithoutNavBar.add("HTC One S");
        devicesWithoutNavBar.add("HTC One X");
        devicesWithoutNavBar.add("HTC One XL");
        hasNavBar = AndroidUtil.isICSOrLater() && !devicesWithoutNavBar.contains(Build.MODEL);
        showInternalStorage = !TextUtils.equals((CharSequence)Build.BRAND, (CharSequence)"Swisscom") && !TextUtils.equals((CharSequence)Build.BOARD, (CharSequence)"sprint");
    }
}

