/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.util;

import java.util.HashMap;
import java.util.Map;

public class ControllerOptions {
    public static final String SEEK = "seek";
    public static final String SCREEN = "screen";
    public static final String MEDIA_LIST = "media_list";
    public static final String RATE = "rate";
    public static final String TOUCH_TO_SEEK = "touch_seek";
    public static final String TOUCH_TO_VOLUME = "touch_volume";
    private Map<String, Boolean> mOptionsMap = new HashMap<String, Boolean>();

    private ControllerOptions() {
    }

    private void addOption(String name, boolean value) {
        this.mOptionsMap.put(name, value);
    }

    public boolean getOption(String name) {
        if (!this.mOptionsMap.containsKey(name)) {
            return false;
        }
        return this.mOptionsMap.get(name);
    }

    public boolean getOption(String name, boolean defaultValue) {
        if (!this.mOptionsMap.containsKey(name)) {
            return defaultValue;
        }
        return this.mOptionsMap.get(name);
    }

    public static ControllerOptions getDefault() {
        ControllerOptions options = new ControllerOptions();
        options.addOption(SEEK, true);
        options.addOption(SCREEN, true);
        options.addOption(MEDIA_LIST, true);
        options.addOption(RATE, true);
        options.addOption(TOUCH_TO_SEEK, true);
        options.addOption(TOUCH_TO_VOLUME, true);
        return options;
    }

    public static class Builder {
        private ControllerOptions mControllerOptions = new ControllerOptions();

        public Builder addOption(String name, boolean value) {
            this.mControllerOptions.addOption(name, value);
            return this;
        }

        public ControllerOptions build() {
            return this.mControllerOptions;
        }
    }
}

