/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.util;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetManager;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import android.text.TextUtils;
import com.edusoho.videoplayer.util.AndroidDevices;
import com.edusoho.videoplayer.util.AndroidUtil;
import com.edusoho.videoplayer.util.Strings;
import com.edusoho.videoplayer.util.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.channels.FileChannel;

public class FileUtils {
    private static final int HASH_CHUNK_SIZE = 65536;

    public static String getFileNameFromPath(String path) {
        if (path == null) {
            return "";
        }
        int index = path.lastIndexOf(47);
        if (index > -1) {
            return path.substring(index + 1);
        }
        return path;
    }

    public static String getParent(String path) {
        int index;
        if (TextUtils.equals((CharSequence)"/", (CharSequence)path)) {
            return path;
        }
        String parentPath = path;
        if (parentPath.endsWith("/")) {
            parentPath = parentPath.substring(0, parentPath.length() - 1);
        }
        if ((index = parentPath.lastIndexOf(47)) > 0) {
            parentPath = parentPath.substring(0, index);
        } else if (index == 0) {
            parentPath = "/";
        }
        return parentPath;
    }

    public static Uri convertLocalUri(Uri uri) {
        if (!TextUtils.equals((CharSequence)uri.getScheme(), (CharSequence)"file") || !uri.getPath().startsWith("/sdcard")) {
            return uri;
        }
        String path = uri.toString();
        return Uri.parse((String)path.replace("/sdcard", AndroidDevices.EXTERNAL_PUBLIC_DIRECTORY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPathFromURI(Context context, Uri contentUri) {
        String string;
        Cursor cursor = null;
        try {
            String[] proj = new String[]{"_data"};
            cursor = context.getContentResolver().query(contentUri, proj, null, null, null);
            int column_index = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            string = cursor.getString(column_index);
        }
        catch (Throwable throwable) {
            Util.close(cursor);
            throw throwable;
        }
        Util.close((Closeable)cursor);
        return string;
    }

    public static boolean copyAssetFolder(AssetManager assetManager, String fromAssetPath, String toPath) {
        try {
            String[] files = assetManager.list(fromAssetPath);
            if (files.length == 0) {
                return false;
            }
            new File(toPath).mkdirs();
            boolean res = true;
            for (String file : files) {
                if (file.contains(".")) {
                    res &= FileUtils.copyAsset(assetManager, fromAssetPath + "/" + file, toPath + "/" + file);
                    continue;
                }
                res &= FileUtils.copyAssetFolder(assetManager, fromAssetPath + "/" + file, toPath + "/" + file);
            }
            return res;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyAsset(AssetManager assetManager, String fromAssetPath, String toPath) {
        boolean bl;
        InputStream in = null;
        FileOutputStream out = null;
        try {
            in = assetManager.open(fromAssetPath);
            new File(toPath).createNewFile();
            out = new FileOutputStream(toPath);
            FileUtils.copyFile(in, out);
            out.flush();
            bl = true;
            Util.close(in);
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl2 = false;
            return bl2;
        }
        finally {
            Util.close(in);
            Util.close(out);
        }
        Util.close(out);
        return bl;
    }

    public static void copyFile(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static boolean copyFile(File src, File dst) {
        boolean ret = true;
        if (src.isDirectory()) {
            File[] filesList = src.listFiles();
            dst.mkdirs();
            for (File file : filesList) {
                ret &= FileUtils.copyFile(file, new File(dst, file.getName()));
            }
        } else if (src.isFile()) {
            boolean bl;
            BufferedInputStream in = null;
            BufferedOutputStream out = null;
            try {
                int len;
                in = new BufferedInputStream(new FileInputStream(src));
                out = new BufferedOutputStream(new FileOutputStream(dst));
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                bl = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Util.close(in);
                Util.close(out);
            }
            catch (IOException iOException) {
                Util.close(in);
                Util.close(out);
                {
                    catch (Throwable throwable) {
                        Util.close(in);
                        Util.close(out);
                        throw throwable;
                    }
                }
            }
            Util.close(in);
            Util.close(out);
            return bl;
            return false;
        }
        return ret;
    }

    @TargetApi(value=11)
    public static boolean deleteFile(Context context, String path) {
        File file;
        boolean deleted = false;
        path = Uri.decode((String)Strings.removeFileProtocole(path));
        if (AndroidUtil.isHoneycombOrLater()) {
            ContentResolver cr = context.getContentResolver();
            String[] selectionArgs = new String[]{path};
            boolean bl = deleted = cr.delete(MediaStore.Files.getContentUri((String)"external"), "_data=?", selectionArgs) > 0;
        }
        if ((file = new File(path)).exists()) {
            deleted |= file.delete();
        }
        return deleted;
    }

    public static boolean canWrite(Context context, Uri uri) {
        if (uri == null) {
            return false;
        }
        if (TextUtils.equals((CharSequence)"file", (CharSequence)uri.getScheme())) {
            return FileUtils.canWrite(uri.toString());
        }
        if (TextUtils.equals((CharSequence)"content", (CharSequence)uri.getScheme())) {
            return FileUtils.canWrite(FileUtils.getPathFromURI(context, uri));
        }
        return false;
    }

    public static boolean canWrite(String path) {
        if (path == null) {
            return false;
        }
        if (path.startsWith("file://")) {
            path = path.substring(7);
        }
        if (!path.startsWith("/")) {
            return false;
        }
        if (path.startsWith(AndroidDevices.EXTERNAL_PUBLIC_DIRECTORY)) {
            return true;
        }
        if (AndroidUtil.isKitKatOrLater()) {
            return false;
        }
        File file = new File(path);
        return file.exists() && file.canWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String computeHash(File file) {
        String string;
        long size = file.length();
        long chunkSizeForFile = Math.min(65536L, size);
        long head = 0L;
        long tail = 0L;
        FileInputStream fis = null;
        FileChannel fileChannel = null;
        try {
            int read;
            fis = new FileInputStream(file);
            fileChannel = fis.getChannel();
            head = FileUtils.computeHashForChunk(fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, chunkSizeForFile));
            ByteBuffer bb = ByteBuffer.allocateDirect((int)chunkSizeForFile);
            long position = Math.max(size - 65536L, 0L);
            while ((read = fileChannel.read(bb, position)) > 0) {
                position += (long)read;
            }
            bb.flip();
            tail = FileUtils.computeHashForChunk(bb);
            string = String.format("%016x", size + head + tail);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            String string2 = null;
            Util.close(fileChannel);
            Util.close(fis);
            return string2;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string3 = null;
            {
                catch (Throwable throwable) {
                    Util.close(fileChannel);
                    Util.close(fis);
                    throw throwable;
                }
            }
            Util.close(fileChannel);
            Util.close(fis);
            return string3;
        }
        Util.close(fileChannel);
        Util.close(fis);
        return string;
    }

    private static long computeHashForChunk(ByteBuffer buffer) {
        LongBuffer longBuffer = buffer.order(ByteOrder.LITTLE_ENDIAN).asLongBuffer();
        long hash = 0L;
        while (longBuffer.hasRemaining()) {
            hash += longBuffer.get();
        }
        return hash;
    }

    public static interface Callback {
        public void onResult(boolean var1);
    }
}

