/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.util;

import com.edusoho.videoplayer.util.Util;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class Logcat
implements Runnable {
    public static final String TAG = "VLC/UiTools/Logcat";
    private Callback mCallback = null;
    private Thread mThread = null;
    private Process mProcess = null;
    private boolean mRun = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        BufferedReader br;
        InputStreamReader input;
        String[] args;
        block9: {
            args = new String[]{"logcat", "-v", "time"};
            input = null;
            br = null;
            Logcat logcat = this;
            // MONITORENTER : logcat
            if (this.mRun) break block9;
            // MONITOREXIT : logcat
            Util.close(input);
            Util.close(br);
            return;
        }
        try {
            String line;
            this.mProcess = Runtime.getRuntime().exec(args);
            input = new InputStreamReader(this.mProcess.getInputStream());
            // MONITOREXIT : logcat
            br = new BufferedReader(input);
            while ((line = br.readLine()) != null) {
                this.mCallback.onLog(line);
            }
        }
        catch (IOException iOException) {
            Util.close(input);
            Util.close(br);
            return;
            catch (Throwable throwable) {
                Util.close(input);
                Util.close(br);
                throw throwable;
            }
        }
        Util.close(input);
        Util.close(br);
        return;
    }

    public synchronized void start(Callback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback should not be null");
        }
        if (this.mThread != null || this.mProcess != null) {
            throw new IllegalStateException("logcat is already started");
        }
        this.mCallback = callback;
        this.mRun = true;
        this.mThread = new Thread(this);
        this.mThread.start();
    }

    public synchronized void stop() {
        this.mRun = false;
        if (this.mProcess != null) {
            this.mProcess.destroy();
            this.mProcess = null;
        }
        try {
            this.mThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.mThread = null;
        this.mCallback = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLogcat(String filename) throws IOException {
        FileOutputStream fileStream;
        String[] args = new String[]{"logcat", "-v", "time", "-d"};
        Process process = Runtime.getRuntime().exec(args);
        InputStreamReader input = new InputStreamReader(process.getInputStream());
        try {
            fileStream = new FileOutputStream(filename);
        }
        catch (FileNotFoundException e) {
            return;
        }
        OutputStreamWriter output = new OutputStreamWriter(fileStream);
        BufferedReader br = new BufferedReader(input);
        BufferedWriter bw = new BufferedWriter(output);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                bw.write(line);
                bw.newLine();
            }
        }
        catch (Exception exception) {
        }
        finally {
            Util.close(bw);
            Util.close(output);
            Util.close(br);
            Util.close(input);
        }
    }

    public static String getLogcat() throws IOException {
        String line;
        String[] args = new String[]{"logcat", "-v", "time", "-d", "-t", "500"};
        Process process = Runtime.getRuntime().exec(args);
        InputStreamReader input = new InputStreamReader(process.getInputStream());
        BufferedReader br = new BufferedReader(input);
        StringBuilder log = new StringBuilder();
        while ((line = br.readLine()) != null) {
            log.append(line + "\n");
        }
        Util.close(br);
        Util.close(input);
        return log.toString();
    }

    public static interface Callback {
        public void onLog(String var1);
    }
}

