/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.preference.PreferenceManager;
import android.provider.Settings;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.edusoho.videoplayer.R;
import com.edusoho.videoplayer.util.AndroidUtil;
import com.edusoho.videoplayer.util.Util;

public class Permissions {
    public static final int PERMISSION_STORAGE_TAG = 255;
    public static final int PERMISSION_SETTINGS_TAG = 254;
    public static final int PERMISSION_SYSTEM_RINGTONE = 42;
    public static final int PERMISSION_SYSTEM_BRIGHTNESS = 43;
    public static final int PERMISSION_SYSTEM_DRAW_OVRLAYS = 44;
    private static Dialog sAlertDialog;

    @TargetApi(value=23)
    public static boolean canDrawOverlays(Context context) {
        return !AndroidUtil.isMarshMallowOrLater() || Settings.canDrawOverlays((Context)context);
    }

    @TargetApi(value=23)
    public static boolean canWriteSettings(Context context) {
        return !AndroidUtil.isMarshMallowOrLater() || Settings.System.canWrite((Context)context);
    }

    public static boolean canReadStorage(Context context) {
        return ContextCompat.checkSelfPermission((Context)context.getApplicationContext(), (String)"android.permission.READ_EXTERNAL_STORAGE") == 0;
    }

    public static void checkReadStoragePermission(Activity activity, boolean exit) {
        if (AndroidUtil.isMarshMallowOrLater() && !Permissions.canReadStorage(activity.getBaseContext())) {
            if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)"android.permission.READ_EXTERNAL_STORAGE")) {
                Permissions.showStoragePermissionDialog(activity, exit);
            } else {
                Permissions.requestStoragePermission(activity);
            }
        }
    }

    public static void checkDrawOverlaysPermission(Activity activity) {
        if (AndroidUtil.isMarshMallowOrLater() && !Permissions.canDrawOverlays((Context)activity)) {
            Permissions.showSettingsPermissionDialog(activity, 44);
        }
    }

    public static void checkWriteSettingsPermission(Activity activity, int mode) {
        if (AndroidUtil.isMarshMallowOrLater() && !Permissions.canWriteSettings((Context)activity)) {
            Permissions.showSettingsPermissionDialog(activity, mode);
        }
    }

    public static void showSettingsPermissionDialog(Activity activity, int mode) {
        if (activity.isFinishing() || sAlertDialog != null && sAlertDialog.isShowing()) {
            return;
        }
        sAlertDialog = Permissions.createSettingsDialogCompat(activity, mode);
    }

    public static void showStoragePermissionDialog(Activity activity, boolean exit) {
        if (activity.isFinishing() || sAlertDialog != null && sAlertDialog.isShowing()) {
            return;
        }
        sAlertDialog = activity instanceof AppCompatActivity ? Permissions.createDialogCompat(activity, exit) : Permissions.createDialog(activity, exit);
    }

    private static Dialog createDialog(final Activity activity, boolean exit) {
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder((Context)activity).setTitle((CharSequence)activity.getString(R.string.allow_storage_access_title)).setMessage((CharSequence)activity.getString(R.string.allow_storage_access_description)).setIcon(17301543).setPositiveButton((CharSequence)activity.getString(R.string.permission_ask_again), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                SharedPreferences settings = PreferenceManager.getDefaultSharedPreferences((Context)activity);
                if (!settings.getBoolean("user_declined_storage_access", false)) {
                    Permissions.requestStoragePermission(activity);
                } else {
                    Intent i = new Intent();
                    i.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
                    i.addCategory("android.intent.category.DEFAULT");
                    i.setData(Uri.parse((String)("package:" + activity.getPackageName())));
                    i.addFlags(0x10000000);
                    try {
                        activity.startActivity(i);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                SharedPreferences.Editor editor = settings.edit();
                editor.putBoolean("user_declined_storage_access", true);
                Util.commitPreferences(editor);
            }
        });
        if (exit) {
            dialogBuilder.setNegativeButton((CharSequence)activity.getString(R.string.exit_app), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    activity.finish();
                }
            }).setCancelable(false);
        }
        return dialogBuilder.show();
    }

    private static Dialog createDialogCompat(final Activity activity, boolean exit) {
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder((Context)activity).setTitle((CharSequence)activity.getString(R.string.allow_storage_access_title)).setMessage((CharSequence)activity.getString(R.string.allow_storage_access_description)).setIcon(17301543).setPositiveButton((CharSequence)activity.getString(R.string.permission_ask_again), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                SharedPreferences settings = PreferenceManager.getDefaultSharedPreferences((Context)activity);
                if (!settings.getBoolean("user_declined_storage_access", false)) {
                    Permissions.requestStoragePermission(activity);
                } else {
                    Intent i = new Intent();
                    i.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
                    i.addCategory("android.intent.category.DEFAULT");
                    i.setData(Uri.parse((String)("package:" + activity.getPackageName())));
                    i.addFlags(0x10000000);
                    try {
                        activity.startActivity(i);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                SharedPreferences.Editor editor = settings.edit();
                editor.putBoolean("user_declined_storage_access", true);
                Util.commitPreferences(editor);
            }
        });
        if (exit) {
            dialogBuilder.setNegativeButton((CharSequence)activity.getString(R.string.exit_app), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    activity.finish();
                }
            }).setCancelable(false);
        }
        return dialogBuilder.show();
    }

    private static Dialog createSettingsDialogCompat(final Activity activity, int mode) {
        int titleId = 0;
        int textId = 0;
        String action = "android.settings.action.MANAGE_WRITE_SETTINGS";
        switch (mode) {
            case 42: {
                titleId = R.string.allow_settings_access_ringtone_title;
                textId = R.string.allow_settings_access_ringtone_description;
                break;
            }
            case 43: {
                titleId = R.string.allow_settings_access_brightness_title;
                textId = R.string.allow_settings_access_brightness_description;
                break;
            }
            case 44: {
                titleId = R.string.allow_draw_overlays_title;
                textId = R.string.allow_sdraw_overlays_description;
                action = "android.settings.action.MANAGE_OVERLAY_PERMISSION";
            }
        }
        final String finalAction = action;
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder((Context)activity).setTitle((CharSequence)activity.getString(titleId)).setMessage((CharSequence)activity.getString(textId)).setIcon(17301543).setPositiveButton((CharSequence)activity.getString(R.string.permission_ask_again), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int whichButton) {
                SharedPreferences settings = PreferenceManager.getDefaultSharedPreferences((Context)activity);
                Intent i = new Intent(finalAction);
                i.setData(Uri.parse((String)("package:" + activity.getPackageName())));
                try {
                    activity.startActivity(i);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SharedPreferences.Editor editor = settings.edit();
                editor.putBoolean("user_declined_settings_access", true);
                Util.commitPreferences(editor);
            }
        });
        return dialogBuilder.show();
    }

    private static void requestStoragePermission(Activity activity) {
        ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, (int)255);
    }
}

