/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;

public class Strings {
    public static final String TAG = "VLC/UiTools/Strings";

    public static String stripTrailingSlash(String s) {
        if (s.endsWith("/") && s.length() > 1) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    static boolean startsWith(String[] array, String text) {
        for (String item : array) {
            if (!text.startsWith(item)) continue;
            return true;
        }
        return false;
    }

    static int containsName(List<String> array, String text) {
        for (int i = array.size() - 1; i >= 0; --i) {
            if (!array.get(i).endsWith(text)) continue;
            return i;
        }
        return -1;
    }

    public static String millisToString(long millis) {
        return Strings.millisToString(millis, false);
    }

    public static String millisToText(long millis) {
        return Strings.millisToString(millis, true);
    }

    static String millisToString(long millis, boolean text) {
        boolean negative = millis < 0L;
        millis = Math.abs(millis);
        int sec = (int)((millis /= 1000L) % 60L);
        int min = (int)((millis /= 60L) % 60L);
        int hours = (int)(millis /= 60L);
        DecimalFormat format = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        format.applyPattern("00");
        String time = text ? (millis > 0L ? (negative ? "-" : "") + hours + "h" + format.format(min) + "min" : (min > 0 ? (negative ? "-" : "") + min + "min" : (negative ? "-" : "") + sec + "s")) : (millis > 0L ? (negative ? "-" : "") + hours + ":" + format.format(min) + ":" + format.format(sec) : (negative ? "-" : "") + min + ":" + format.format(sec));
        return time;
    }

    public static boolean nullEquals(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public static String formatRateString(float rate) {
        return String.format(Locale.US, "%.2fx", Float.valueOf(rate));
    }

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "KiB", "MiB", "GiB", "TiB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public static String readableSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1000.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1000.0, digitGroups)) + " " + units[digitGroups];
    }

    public static String removeFileProtocole(String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith("file://")) {
            return path.substring(7);
        }
        return path;
    }
}

