/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.util;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Looper;
import androidx.annotation.Nullable;
import com.edusoho.videoplayer.util.AndroidUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.List;

public class Util {
    public static final String TAG = "VLC/Util";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAsset(Context context, String assetName, String defaultS) {
        String string;
        InputStream is = null;
        BufferedReader r = null;
        try {
            is = context.getAssets().open(assetName);
            r = new BufferedReader(new InputStreamReader(is, "UTF8"));
            StringBuilder sb = new StringBuilder();
            String line = r.readLine();
            if (line != null) {
                sb.append(line);
                line = r.readLine();
                while (line != null) {
                    sb.append('\n');
                    sb.append(line);
                    line = r.readLine();
                }
            }
            string = sb.toString();
        }
        catch (IOException e) {
            String string2;
            try {
                string2 = defaultS;
            }
            catch (Throwable throwable) {
                Util.close(is);
                Util.close(r);
                throw throwable;
            }
            Util.close(is);
            Util.close(r);
            return string2;
        }
        Util.close(is);
        Util.close(r);
        return string;
    }

    @TargetApi(value=9)
    public static void commitPreferences(SharedPreferences.Editor editor) {
        if (AndroidUtil.isGingerbreadOrLater()) {
            editor.apply();
        } else {
            editor.commit();
        }
    }

    public static boolean close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isListEmpty(@Nullable Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isCallable(Context context, Intent intent) {
        List list = context.getPackageManager().queryIntentActivities(intent, 65536);
        return list.size() > 0;
    }

    public static Looper getLooper() {
        Looper myLooper = Looper.myLooper();
        return myLooper != null ? myLooper : Looper.getMainLooper();
    }
}

