/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.view;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.net.Uri;
import android.os.Handler;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import androidx.annotation.Nullable;
import com.edusoho.videoplayer.R;
import com.edusoho.videoplayer.broadcast.MessageBroadcastReceiver;
import com.edusoho.videoplayer.error.HlsSourceIOException;
import com.edusoho.videoplayer.helper.ControllerViewTouchHelper;
import com.edusoho.videoplayer.media.EduExoPlayer;
import com.edusoho.videoplayer.media.ILogoutListener;
import com.edusoho.videoplayer.media.IPlayerStateListener;
import com.edusoho.videoplayer.media.IVideoPlayer;
import com.edusoho.videoplayer.media.encrypt.EncryptDataSourceFactory;
import com.edusoho.videoplayer.media.encrypt.EncryptHttpDataSourceFactory;
import com.edusoho.videoplayer.util.ControllerOptions;
import com.edusoho.videoplayer.view.VideoControllerView;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MergingMediaSource;
import com.google.android.exoplayer2.source.SingleSampleMediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.source.dash.DashChunkSource;
import com.google.android.exoplayer2.source.dash.DashMediaSource;
import com.google.android.exoplayer2.source.dash.DefaultDashChunkSource;
import com.google.android.exoplayer2.source.hls.HlsMediaSource;
import com.google.android.exoplayer2.source.smoothstreaming.DefaultSsChunkSource;
import com.google.android.exoplayer2.source.smoothstreaming.SsChunkSource;
import com.google.android.exoplayer2.source.smoothstreaming.SsMediaSource;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.TextOutput;
import com.google.android.exoplayer2.text.TextRenderer;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.ui.AspectRatioFrameLayout;
import com.google.android.exoplayer2.ui.SubtitleView;
import com.google.android.exoplayer2.ui.spherical.SphericalSurfaceView;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSpec;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoListener;
import java.util.List;

@TargetApi(value=16)
public class EduExoPlayerView
extends FrameLayout
implements IVideoPlayer {
    static final String TAG = "EduExoPlayerView";
    private final View surfaceView;
    private final AspectRatioFrameLayout contentFrame;
    private final ComponentListener componentListener;
    private EduExoPlayer player;
    private SubtitleView subtitleView;
    private ProgressBar mProgressView;
    private VideoControllerView mVideoControllerView;
    private Handler mainHandler;
    private String mMediaUrl;
    private List<Uri> mSubtitlesUris;
    private String mDigestKey;
    private boolean isAttachedToWindow;
    private int mMediaCoder;
    private int mCurrentPlayState;
    private int mSurfaceState;
    private int textureViewRotation;
    private long mSeekPosition = -1L;
    private final int STATE_CREATE = 1;
    private final int STATE_DESTORY = 2;
    private final int STATE_NOMAL = 3;
    private ILogoutListener mLogoutListener;
    private IPlayerStateListener mIPlayerStateListener;
    private MediaSource mCurrentSubtitleMediaSource;
    private final Runnable updateProgressAction = this::updateMediaProgress;
    private static DefaultBandwidthMeter singletonBandwidthMeter = new DefaultBandwidthMeter();

    public EduExoPlayerView(Context context) {
        this(context, null);
    }

    public EduExoPlayerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EduExoPlayerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        boolean useTextureView = false;
        LayoutInflater.from((Context)context).inflate(R.layout.view_exoplayer_layout, (ViewGroup)this);
        this.componentListener = new ComponentListener();
        singletonBandwidthMeter = new DefaultBandwidthMeter.Builder(context).build();
        this.contentFrame = (AspectRatioFrameLayout)this.findViewById(R.id.arf_exo_content);
        TextureView view = useTextureView ? new TextureView(context) : new SurfaceView(context);
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        view.setLayoutParams(params);
        this.surfaceView = view;
        this.contentFrame.addView(this.surfaceView, 0);
        this.subtitleView = (SubtitleView)this.findViewById(R.id.exo_subtitles);
        this.subtitleView.setUserDefaultStyle();
        this.subtitleView.setUserDefaultTextSize();
        this.onCreateView();
    }

    public void setMediaCoder(int mMediaCoder) {
        this.mMediaCoder = mMediaCoder;
    }

    private void onCreateView() {
        this.mProgressView = (ProgressBar)this.findViewById(R.id.pb_player_progress);
        this.mainHandler = new Handler();
    }

    private void startPlayback() {
        if (this.player == null) {
            this.player = this.initializePlayer();
            this.setPlayer(this.player);
        }
        MediaSource videoSource = this.buildMediaSource(Uri.parse((String)this.mMediaUrl));
        if (this.mSubtitlesUris != null && this.mSubtitlesUris.size() > 0) {
            Format subtitleFormat = Format.createTextSampleFormat(null, (String)"application/x-subrip", (int)1, (String)"");
            MediaSource[] subtitleSources = new MediaSource[2];
            subtitleSources[0] = videoSource;
            int i = 1;
            subtitleSources[i] = this.mCurrentSubtitleMediaSource = new SingleSampleMediaSource.Factory((DataSource.Factory)this.getDataSourceFactory()).createMediaSource(this.mSubtitlesUris.get(0), subtitleFormat, -9223372036854775807L);
            MergingMediaSource mergingMediaSource = new MergingMediaSource(new MediaSource[]{videoSource, subtitleSources[i]});
            this.player.prepare((MediaSource)mergingMediaSource);
        } else {
            this.player.prepare(videoSource);
        }
    }

    private MediaSource buildMediaSource(Uri uri) {
        DataSource.Factory mediaDataSourceFactory = this.buildDataSourceFactory(singletonBandwidthMeter);
        int type = Util.inferContentType((String)uri.getLastPathSegment());
        Log.d((String)"flag--", (String)"buildMediaSource: ");
        switch (type) {
            case 1: {
                return new SsMediaSource(uri, (DataSource.Factory)this.getDataSourceFactory(), (SsChunkSource.Factory)new DefaultSsChunkSource.Factory(mediaDataSourceFactory), this.mainHandler, null);
            }
            case 0: {
                return new DashMediaSource(uri, (DataSource.Factory)this.getDataSourceFactory(), (DashChunkSource.Factory)new DefaultDashChunkSource.Factory(mediaDataSourceFactory), this.mainHandler, null);
            }
            case 2: {
                return new HlsMediaSource.Factory(mediaDataSourceFactory).createMediaSource(uri);
            }
            case 3: {
                return new ExtractorMediaSource(uri, mediaDataSourceFactory, (ExtractorsFactory)new DefaultExtractorsFactory(), this.mainHandler, null);
            }
        }
        if (this.mLogoutListener != null) {
            this.mLogoutListener.onLog(TAG, "Unsupported type: " + type);
        }
        throw new IllegalStateException("Unsupported type: " + type);
    }

    private String getUserAgent() {
        return Util.getUserAgent((Context)this.getContext(), (String)"kuozhi-Android-exo-player-1.4.8");
    }

    public DataSource.Factory buildDataSourceFactory(DefaultBandwidthMeter bandwidthMeter) {
        return new EncryptDataSourceFactory(this.getContext(), this.mDigestKey, (TransferListener)bandwidthMeter, (DataSource.Factory)new EncryptHttpDataSourceFactory(this.getUserAgent(), (TransferListener)bandwidthMeter));
    }

    private DefaultDataSourceFactory getDataSourceFactory() {
        return new DefaultDataSourceFactory(this.getContext(), this.getUserAgent());
    }

    private EduExoPlayer initializePlayer() {
        AdaptiveTrackSelection.Factory videoTrackSelectionFactory = new AdaptiveTrackSelection.Factory();
        DefaultTrackSelector trackSelector = new DefaultTrackSelector((TrackSelection.Factory)videoTrackSelectionFactory);
        EduExoPlayer player = new EduExoPlayer(this.getContext(), (BandwidthMeter)singletonBandwidthMeter, (TrackSelector)trackSelector, (LoadControl)new DefaultLoadControl(), null);
        player.setPlayWhenReady(true);
        return player;
    }

    protected VideoControllerView.ControllerListener getDefaultControllerListener() {
        return new VideoControllerView.ControllerListener(){

            @Override
            public void onSeek(int position) {
                if (EduExoPlayerView.this.player != null) {
                    EduExoPlayerView.this.player.seekTo(position);
                }
            }

            @Override
            public void onChangeScreen(int orientation) {
            }

            @Override
            public void onPlayStatusChange(boolean isPlay) {
                Log.d((String)EduExoPlayerView.TAG, (String)("onPlayStatusChange:" + isPlay));
                if (isPlay) {
                    if (EduExoPlayerView.this.mCurrentPlayState == 4) {
                        EduExoPlayerView.this.startPlayback();
                        return;
                    }
                    EduExoPlayerView.this.play();
                } else {
                    EduExoPlayerView.this.pause();
                }
            }

            @Override
            public void onChangeRate(float rate) {
                if (EduExoPlayerView.this.player != null) {
                    EduExoPlayerView.this.player.setRate(rate);
                }
            }

            @Override
            public void onChangePlaySource(String url) {
                if (EduExoPlayerView.this.mCurrentSubtitleMediaSource == null) {
                    MediaSource mediaSource = EduExoPlayerView.this.buildMediaSource(Uri.parse((String)url));
                    EduExoPlayerView.this.player.prepare(mediaSource, false, true);
                } else {
                    MediaSource mediaSource = EduExoPlayerView.this.buildMediaSource(Uri.parse((String)url));
                    MergingMediaSource mergingMediaSource = new MergingMediaSource(new MediaSource[]{mediaSource, EduExoPlayerView.this.mCurrentSubtitleMediaSource});
                    EduExoPlayerView.this.player.prepare((MediaSource)mergingMediaSource, false, true);
                }
            }

            @Override
            public void onChangeOverlay(boolean isShow) {
            }
        };
    }

    public void setPlayer(EduExoPlayer player) {
        if (this.player != null) {
            this.player.removeListener(this.componentListener);
            this.player.removeTextOutput((TextOutput)this.componentListener);
            this.player.removeVideoListener((VideoListener)this.componentListener);
            if (this.surfaceView instanceof TextureView) {
                this.player.clearVideoTextureView((TextureView)this.surfaceView);
            } else if (this.surfaceView instanceof SurfaceView) {
                this.player.clearVideoSurfaceView((SurfaceView)this.surfaceView);
            }
        }
        this.player = player;
        if (this.subtitleView != null) {
            this.subtitleView.setCues(null);
        }
        if (player != null) {
            if (this.surfaceView instanceof TextureView) {
                player.setVideoTextureView((TextureView)this.surfaceView);
            } else if (this.surfaceView instanceof SurfaceView) {
                player.setVideoSurfaceView((SurfaceView)this.surfaceView);
                ((SurfaceView)this.surfaceView).getHolder().addCallback(new SurfaceHolder.Callback(){

                    public void surfaceCreated(SurfaceHolder holder) {
                        EduExoPlayerView.this.mSurfaceState = 1;
                    }

                    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                    }

                    public void surfaceDestroyed(SurfaceHolder holder) {
                        EduExoPlayerView.this.mSurfaceState = 2;
                    }
                });
            }
            player.addVideoListener((VideoListener)this.componentListener);
            player.addTextOutput((TextOutput)this.componentListener);
            player.addListener(this.componentListener);
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mVideoControllerView != null && ev.getActionMasked() == 0) {
            if (this.mVideoControllerView.getVisibility() == 0) {
                this.mVideoControllerView.setVisibility(4);
            } else {
                this.mVideoControllerView.setVisibility(0);
            }
        }
        return true;
    }

    public boolean onTrackballEvent(MotionEvent ev) {
        if (this.mVideoControllerView == null) {
            return false;
        }
        this.mVideoControllerView.setVisibility(0);
        return true;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        return this.mVideoControllerView != null ? this.mVideoControllerView.dispatchKeyEvent(event) : super.dispatchKeyEvent(event);
    }

    private void releasePlayer() {
        if (this.player != null) {
            this.player.stop();
            this.player.release();
            this.player = null;
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.isAttachedToWindow = true;
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.isAttachedToWindow = false;
        this.removeCallbacks(this.updateProgressAction);
    }

    private synchronized void validToSeek(long seekPosition) {
        if (this.mSurfaceState != 1) {
            return;
        }
        if (this.mSeekPosition == -1L) {
            return;
        }
        Log.d((String)TAG, (String)("validToSeek: " + seekPosition));
        this.player.seekTo(seekPosition);
        this.mSurfaceState = 3;
    }

    protected void onContentAspectRatioChanged(float contentAspectRatio, @Nullable AspectRatioFrameLayout contentFrame, @Nullable View contentView) {
        if (contentFrame != null) {
            contentFrame.setAspectRatio(contentView instanceof SphericalSurfaceView ? 0.0f : contentAspectRatio);
        }
    }

    private void updateMediaProgress() {
        int playbackState;
        if (this.getVisibility() != 0 || !this.isAttachedToWindow || this.player == null || !this.player.getPlayWhenReady() || this.player.getPlaybackState() == 2) {
            return;
        }
        this.mVideoControllerView.updateMediaProgress((int)this.player.getCurrentPosition(), (int)this.player.getDuration());
        this.removeCallbacks(this.updateProgressAction);
        int n = playbackState = this.player == null ? 1 : this.player.getPlaybackState();
        if (playbackState != 1 && playbackState != 4) {
            this.postDelayed(this.updateProgressAction, 300L);
        }
    }

    @Override
    public void onStart() {
        Log.d((String)TAG, (String)"onStart");
        if (this.player != null && this.player.getPlaybackState() == 3) {
            this.player.setPlayWhenReady(true);
            this.mSeekPosition -= 2000L;
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.mMediaUrl)) {
            this.startPlayback();
        }
    }

    @Override
    public void onStop() {
        this.releasePlayer();
    }

    @Override
    public void setSeekPosition(long seekPosition) {
        if (this.player == null) {
            return;
        }
        Log.d((String)TAG, (String)("seekPosition:" + seekPosition));
        if (seekPosition > 0L) {
            this.player.seekTo(seekPosition);
        }
    }

    @Override
    public void addPlayerStateListener(IPlayerStateListener listener) {
        this.mIPlayerStateListener = listener;
        if (!TextUtils.isEmpty((CharSequence)this.mMediaUrl)) {
            this.mIPlayerStateListener.onPrepare();
        }
    }

    @Override
    public void addVideoController(VideoControllerView videoControllerView) {
        this.mVideoControllerView = videoControllerView;
        ControllerOptions options = new ControllerOptions.Builder().addOption("rate", this.mMediaCoder == 1).addOption("screen", true).build();
        this.mVideoControllerView.setControllerOptions(options);
        this.mVideoControllerView.setControllerListener(this.getDefaultControllerListener());
    }

    @Override
    public void play() {
        if (this.player == null) {
            return;
        }
        this.player.setPlayWhenReady(true);
    }

    @Override
    public void pause() {
        if (this.player == null) {
            return;
        }
        this.mSeekPosition = this.player.getCurrentPosition();
        this.player.setPlayWhenReady(false);
    }

    @Override
    public void setMediaSource(String url) {
        this.mMediaUrl = url;
    }

    @Override
    public void setSubtitlesUrls(List<Uri> subtitlesUris) {
        this.mSubtitlesUris = subtitlesUris;
    }

    @Override
    public void start() {
        this.startPlayback();
    }

    @Override
    public View getView() {
        return this;
    }

    @Override
    public long getPosition() {
        return this.player == null ? 0L : this.player.getCurrentPosition();
    }

    @Override
    public long getVideoLength() {
        return this.player == null ? 0L : this.player.getDuration();
    }

    @Override
    public void setDigestKey(String digestKey) {
        this.mDigestKey = digestKey;
    }

    @Override
    public void addLogListener(ILogoutListener logoutListener) {
        this.mLogoutListener = logoutListener;
    }

    @Override
    public void setRate(float rate) {
        if (this.player != null) {
            this.player.setRate(rate);
        }
    }

    private static void applyTextureViewRotation(TextureView textureView, int textureViewRotation) {
        float textureViewWidth = textureView.getWidth();
        float textureViewHeight = textureView.getHeight();
        if (textureViewWidth == 0.0f || textureViewHeight == 0.0f || textureViewRotation == 0) {
            textureView.setTransform(null);
        } else {
            Matrix transformMatrix = new Matrix();
            float pivotX = textureViewWidth / 2.0f;
            float pivotY = textureViewHeight / 2.0f;
            transformMatrix.postRotate((float)textureViewRotation, pivotX, pivotY);
            RectF originalTextureRect = new RectF(0.0f, 0.0f, textureViewWidth, textureViewHeight);
            RectF rotatedTextureRect = new RectF();
            transformMatrix.mapRect(rotatedTextureRect, originalTextureRect);
            transformMatrix.postScale(textureViewWidth / rotatedTextureRect.width(), textureViewHeight / rotatedTextureRect.height(), pivotX, pivotY);
            textureView.setTransform(transformMatrix);
        }
    }

    private final class ComponentListener
    implements SimpleExoPlayer.VideoListener,
    TextRenderer.Output,
    Player.EventListener,
    View.OnLayoutChangeListener {
        private ComponentListener() {
        }

        public void onIsPlayingChanged(boolean isPlaying) {
            Log.d((String)EduExoPlayerView.TAG, (String)("onIsPlayingChanged: " + isPlaying));
        }

        public void onCues(List<Cue> cues) {
            if (EduExoPlayerView.this.subtitleView != null) {
                EduExoPlayerView.this.subtitleView.onCues(cues);
            }
        }

        public void onRenderedFirstFrame() {
        }

        public void onSurfaceSizeChanged(int width, int height) {
            Log.d((String)EduExoPlayerView.TAG, (String)("onSurfaceSizeChanged: " + width + "," + height));
        }

        public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
            float videoAspectRatio;
            ControllerViewTouchHelper touchHelper = new ControllerViewTouchHelper((Activity)EduExoPlayerView.this.getContext());
            touchHelper.updateVideoSize(width, height);
            EduExoPlayerView.this.mVideoControllerView.setControllerViewTouchHelper(touchHelper);
            float f = videoAspectRatio = height == 0 || width == 0 ? 1.0f : (float)width * pixelWidthHeightRatio / (float)height;
            if (EduExoPlayerView.this.surfaceView instanceof TextureView) {
                if (unappliedRotationDegrees == 90 || unappliedRotationDegrees == 270) {
                    videoAspectRatio = 1.0f / videoAspectRatio;
                }
                if (EduExoPlayerView.this.textureViewRotation != 0) {
                    EduExoPlayerView.this.surfaceView.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                }
                EduExoPlayerView.this.textureViewRotation = unappliedRotationDegrees;
                if (EduExoPlayerView.this.textureViewRotation != 0) {
                    EduExoPlayerView.this.surfaceView.addOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                }
                EduExoPlayerView.applyTextureViewRotation((TextureView)EduExoPlayerView.this.surfaceView, EduExoPlayerView.this.textureViewRotation);
            }
            EduExoPlayerView.this.onContentAspectRatioChanged(videoAspectRatio, EduExoPlayerView.this.contentFrame, EduExoPlayerView.this.surfaceView);
        }

        public void onLayoutChange(View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            EduExoPlayerView.applyTextureViewRotation((TextureView)view, EduExoPlayerView.this.textureViewRotation);
        }

        public void onTracksChanged(TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
        }

        public void onLoadingChanged(boolean isLoading) {
        }

        public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
            Log.d((String)EduExoPlayerView.TAG, (String)("playbackState:" + playbackState));
            EduExoPlayerView.this.mCurrentPlayState = playbackState;
            if (EduExoPlayerView.this.mIPlayerStateListener != null && playWhenReady && playbackState == 4) {
                EduExoPlayerView.this.mIPlayerStateListener.onFinish();
            }
            if (EduExoPlayerView.this.mVideoControllerView != null && playbackState == 4) {
                EduExoPlayerView.this.mVideoControllerView.setVisibility(0);
            }
            if (EduExoPlayerView.this.mIPlayerStateListener != null && EduExoPlayerView.this.mVideoControllerView != null && playbackState == 3) {
                EduExoPlayerView.this.mIPlayerStateListener.onPlaying();
                EduExoPlayerView.this.validToSeek(EduExoPlayerView.this.mSeekPosition);
            }
            EduExoPlayerView.this.mVideoControllerView.updatePlayStatus(playWhenReady);
            EduExoPlayerView.this.mProgressView.setVisibility(playbackState == 2 ? 0 : 4);
            if (playWhenReady) {
                EduExoPlayerView.this.updateMediaProgress();
            }
            if (playbackState == 4) {
                EduExoPlayerView.this.pause();
                EduExoPlayerView.this.releasePlayer();
            }
        }

        public void onPlayerError(ExoPlaybackException e) {
            Throwable ioException = e.getCause();
            if (ioException != null) {
                if (ioException instanceof HlsSourceIOException) {
                    DataSpec dataSpec = ((HlsSourceIOException)ioException).getDataSpec();
                    String message = dataSpec != null ? dataSpec.uri.getPath() : "";
                    EduExoPlayerView.this.getContext().sendBroadcast(MessageBroadcastReceiver.getIntent("VideoFileNotFound", message));
                } else {
                    StackTraceElement[] stackTraceElements = ioException.getStackTrace();
                    if (stackTraceElements != null) {
                        for (StackTraceElement element : stackTraceElements) {
                            if (!"android.media.MediaCodec".equals(element.getClassName())) continue;
                            EduExoPlayerView.this.getContext().sendBroadcast(MessageBroadcastReceiver.getIntent("MediaCodecError", ""));
                            break;
                        }
                    }
                }
            }
            if (EduExoPlayerView.this.mLogoutListener != null) {
                EduExoPlayerView.this.mLogoutListener.onLog("onPlayerError", e);
            }
        }

        public void onTimelineChanged(Timeline timeline, @Nullable Object manifest, int reason) {
        }

        public void onRepeatModeChanged(int repeatMode) {
        }

        public void onShuffleModeEnabledChanged(boolean shuffleModeEnabled) {
        }

        public void onPositionDiscontinuity(int reason) {
        }

        public void onPlaybackParametersChanged(PlaybackParameters playbackParameters) {
        }

        public void onSeekProcessed() {
        }
    }
}

