/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.edusoho.videoplayer.R;
import com.edusoho.videoplayer.util.Strings;

public class SeekChangeBarView
extends FrameLayout {
    private static final int FADE_OUT_INFO = 0;
    private TextView mSeekInfoView;
    private ImageView mSeekIconView;
    private Handler mHandler;

    public SeekChangeBarView(Context context) {
        super(context, null);
        this.initView();
    }

    public SeekChangeBarView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs, 0);
        this.initView();
    }

    @TargetApi(value=21)
    public SeekChangeBarView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr, 0);
        this.initView();
    }

    protected void initBackground() {
        Drawable background = this.getResources().getDrawable(R.drawable.controller_play_seek_bg);
        background.setAlpha(128);
        this.setBackground(background);
    }

    protected void initView() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.view_seek_change_bar_layout, (ViewGroup)this, true);
        this.mSeekInfoView = (TextView)this.findViewById(R.id.tv_seek_info);
        this.mSeekIconView = (ImageView)this.findViewById(R.id.tv_seek_icon);
        this.initBackground();
        this.mHandler = new Handler(){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                switch (msg.what) {
                    case 0: {
                        SeekChangeBarView.this.hideInfo();
                    }
                }
            }
        };
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mHandler.removeMessages(0);
    }

    private void hideInfo() {
        this.startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)0x10A0001));
        this.setVisibility(4);
    }

    public void showInfo(int coef, int jump, long time, long length) {
        this.updateSeekIcon(jump < 0);
        this.mSeekInfoView.setText((CharSequence)SeekChangeBarView.getCoverSeekColorText(Strings.millisToString((long)jump + time), "/" + Strings.millisToString(length), this.getResources().getColor(R.color.seek_secondary_text)));
        this.setVisibility(0);
        this.mHandler.removeMessages(0);
        this.mHandler.sendEmptyMessageDelayed(0, 1000L);
    }

    public static SpannableString getCoverSeekColorText(String text, String newStr, int color2) {
        StringBuffer stringBuffer = new StringBuffer(text);
        int start = stringBuffer.length();
        stringBuffer.append(newStr);
        SpannableString spannableString = new SpannableString((CharSequence)stringBuffer);
        spannableString.setSpan((Object)new ForegroundColorSpan(color2), start, stringBuffer.length(), 34);
        return spannableString;
    }

    private void updateSeekIcon(boolean isBack) {
        this.mSeekIconView.setImageResource(isBack ? R.drawable.ic_controller_back : R.drawable.ic_controller_forward);
    }
}

