/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.view.GestureDetectorCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.edusoho.videoplayer.R;
import com.edusoho.videoplayer.helper.ControllerViewTouchHelper;
import com.edusoho.videoplayer.media.M3U8Stream;
import com.edusoho.videoplayer.ui.adapter.OnItemClickListener;
import com.edusoho.videoplayer.ui.adapter.StreamListAdapter;
import com.edusoho.videoplayer.util.ControllerOptions;
import com.edusoho.videoplayer.util.Strings;
import com.edusoho.videoplayer.view.ListDecoration;
import com.edusoho.videoplayer.view.SeekChangeBarView;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class VideoControllerView
extends FrameLayout {
    private static final int FADE_OUT = 1;
    private static final int DEFAULT_TIMEOUT_COUNT = 5000;
    static String TAG = "VideoControllerView";
    protected SeekBar mProgressView;
    protected TextView mTimeView;
    protected TextView mRateView;
    protected TextView mStreamListView;
    protected ImageView mPlayBtn;
    private CheckBox mScreenChangeView;
    private PopupWindow streamListPopupWindow;
    private List<ControllerListener> mControllerListenerList;
    private Handler mHandler;
    private String mCurrentStreamName;
    private Map<String, M3U8Stream> mM3U8StreamList;
    private float[] defaultRateArray;
    private int mCurrentRateIndex = 1;
    private int mOrientation;
    private int mSecProcess;
    private View mToolsView;
    private boolean isSeekByUser;
    private SeekChangeBarView mSeekChangeBarView;
    private ControllerViewTouchHelper mControllerViewTouchHelper;
    private GestureDetectorCompat mGestureDetector;
    private ControllerOptions mControllerOptions;
    private boolean isCached;
    private boolean mSeekToDropForwardEnable;
    private int mNaturalSeekProgress;
    private boolean mProgressViewSeekEnable = true;
    private GestureDetector.OnGestureListener mGestureListener = new GestureDetector.OnGestureListener(){

        public boolean onDown(MotionEvent e) {
            return false;
        }

        public void onShowPress(MotionEvent e) {
        }

        public boolean onSingleTapUp(MotionEvent e) {
            return false;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            return false;
        }

        public void onLongPress(MotionEvent e) {
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            return false;
        }
    };

    public VideoControllerView(Context context) {
        super(context, null);
        this.initView();
    }

    public VideoControllerView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs, 0);
        this.initView();
    }

    @TargetApi(value=21)
    public VideoControllerView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr, 0);
        this.initView();
    }

    public void setControllerOptions(ControllerOptions controllerOptions) {
        this.mControllerOptions = controllerOptions;
        this.renderViewByOptions();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.streamListPopupWindow != null) {
            this.streamListPopupWindow.dismiss();
            this.streamListPopupWindow = null;
        }
        this.mHandler.removeMessages(1);
    }

    public void setControllerViewTouchHelper(ControllerViewTouchHelper controllerViewTouchHelper) {
        controllerViewTouchHelper.setControllerView(this);
        this.mControllerViewTouchHelper = controllerViewTouchHelper;
    }

    public Map<String, M3U8Stream> getM3U8StreamList() {
        return this.mM3U8StreamList;
    }

    public void setM3U8StreamList(List<M3U8Stream> mM3U8StreamList) {
        LinkedHashMap<String, M3U8Stream> m3U8StreamMap = new LinkedHashMap<String, M3U8Stream>();
        for (M3U8Stream m3U8Stream : mM3U8StreamList) {
            m3U8StreamMap.put(m3U8Stream.getKey(), m3U8Stream);
        }
        this.mM3U8StreamList = m3U8StreamMap;
        if (mM3U8StreamList != null && !mM3U8StreamList.isEmpty()) {
            if (TextUtils.isEmpty((CharSequence)this.mCurrentStreamName)) {
                this.mCurrentStreamName = mM3U8StreamList.get(0).getKey();
            }
            this.updateStreamListView(this.mCurrentStreamName);
        }
    }

    public SeekChangeBarView getSeekChangeBarView() {
        return this.mSeekChangeBarView;
    }

    public void setSeekChangeBarView(SeekChangeBarView seekChangeBarView) {
        this.mSeekChangeBarView = seekChangeBarView;
    }

    public void setControllerListener(ControllerListener controllerListener) {
        this.mControllerListenerList.add(controllerListener);
    }

    public void clearControllerListener() {
        this.mControllerListenerList.clear();
    }

    protected void initView() {
        this.mOrientation = this.getContext().getResources().getConfiguration().orientation;
        this.setDescendantFocusability(131072);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.content_video_controller_layout, (ViewGroup)this, true);
        this.mScreenChangeView = (CheckBox)this.findViewById(R.id.cb_controller_screen);
        this.mPlayBtn = (ImageView)this.findViewById(R.id.tv_controller_play);
        this.mProgressView = (SeekBar)this.findViewById(R.id.sb_controller_progress);
        this.mTimeView = (TextView)this.findViewById(R.id.tv_controller_time);
        this.mStreamListView = (TextView)this.findViewById(R.id.tv_controller_streamlist);
        this.mRateView = (TextView)this.findViewById(R.id.tv_controller_rate);
        this.mToolsView = this.findViewById(R.id.ll_controller_tools);
        this.mSeekChangeBarView = (SeekChangeBarView)this.findViewById(R.id.sbview_controller_seekinfo);
        this.mControllerListenerList = new LinkedList<ControllerListener>();
        this.setControllerOptions(ControllerOptions.getDefault());
        this.mPlayBtn.setSelected(false);
        this.bindControllerListener();
        this.setDefaultRateArray(new float[]{0.8f, 1.0f, 1.25f, 1.5f, 2.0f});
        this.updateRateView(this.defaultRateArray[this.mCurrentRateIndex]);
        this.mHandler = new Handler(){

            public void handleMessage(Message msg) {
                super.handleMessage(msg);
                switch (msg.what) {
                    case 1: {
                        VideoControllerView.this.hideOverlay();
                    }
                }
            }
        };
        this.mGestureDetector = new GestureDetectorCompat(this.getContext(), this.mGestureListener);
        this.mGestureDetector.setOnDoubleTapListener(this.getScreenDoubleTapListener());
        this.mGestureDetector.setIsLongpressEnabled(false);
    }

    private void renderViewByOptions() {
        boolean isShowRate = this.mControllerOptions.getOption("rate") & this.mOrientation == 2;
        ((View)this.mRateView.getParent()).setVisibility(isShowRate ? 0 : 8);
        this.mScreenChangeView.setVisibility(this.mControllerOptions.getOption("screen") ? 0 : 8);
        this.mProgressView.setEnabled(this.mControllerOptions.getOption("seek", true));
    }

    protected GestureDetector.OnDoubleTapListener getScreenDoubleTapListener() {
        return new GestureDetector.OnDoubleTapListener(){

            public boolean onSingleTapConfirmed(MotionEvent e) {
                return false;
            }

            public boolean onDoubleTap(MotionEvent e) {
                VideoControllerView.this.mPlayBtn.setSelected(!VideoControllerView.this.mPlayBtn.isSelected());
                for (ControllerListener listener : VideoControllerView.this.mControllerListenerList) {
                    listener.onPlayStatusChange(VideoControllerView.this.mPlayBtn.isSelected());
                }
                return true;
            }

            public boolean onDoubleTapEvent(MotionEvent e) {
                return false;
            }
        };
    }

    public void showControllerBar(boolean show) {
        if (show) {
            this.showOverlay(5000);
        } else {
            this.hideOverlayDelayed(5000);
        }
    }

    private void showOverlay(int overlayTimeout) {
        this.mToolsView.setVisibility(0);
        if (this.getBackground() == null) {
            this.setBackgroundResource(R.drawable.video_controller_view_bg);
        }
        this.getBackground().setAlpha(128);
        this.mHandler.removeMessages(1);
        if (overlayTimeout > 0) {
            this.hideOverlayDelayed(overlayTimeout);
        }
        for (ControllerListener listener : this.mControllerListenerList) {
            listener.onChangeOverlay(true);
        }
    }

    private void hideOverlayDelayed(int overlayTimeout) {
        this.mHandler.removeMessages(1);
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1), (long)overlayTimeout);
    }

    private void hideOverlay() {
        if (this.getBackground() == null) {
            this.setBackgroundResource(R.drawable.video_controller_view_bg);
        }
        this.getBackground().setAlpha(0);
        this.hidePopWindows();
        this.mToolsView.setVisibility(4);
        this.mHandler.removeMessages(1);
        for (ControllerListener listener : this.mControllerListenerList) {
            listener.onChangeOverlay(false);
        }
    }

    protected void bindControllerListener() {
        this.mPlayBtn.setOnClickListener(this.getPlayClickListener());
        ((View)this.mRateView.getParent()).setOnClickListener(this.getRateClickListener());
        ((View)this.mStreamListView.getParent()).setOnClickListener(this.getStreamListClickListener());
        this.mScreenChangeView.setOnCheckedChangeListener(this.getOnScreenChangeListener());
        this.mProgressView.setOnSeekBarChangeListener(this.getOnProgressChangeListener());
        this.mToolsView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                VideoControllerView.this.hideOverlayDelayed(5000);
                return true;
            }
        });
    }

    public M3U8Stream getCurrentM3U8Stream() {
        if (TextUtils.isEmpty((CharSequence)this.mCurrentStreamName) || this.mM3U8StreamList == null || this.mM3U8StreamList.isEmpty()) {
            return null;
        }
        return this.mM3U8StreamList.get(this.mCurrentStreamName);
    }

    protected void updateStreamListView(String streamIndex) {
        if (TextUtils.isEmpty((CharSequence)streamIndex) || !this.mM3U8StreamList.containsKey(this.mCurrentStreamName)) {
            return;
        }
        this.mStreamListView.setText((CharSequence)this.mM3U8StreamList.get(this.mCurrentStreamName).getKey());
    }

    protected void updateRateView(float rate) {
        this.mRateView.setText((CharSequence)(rate + "x"));
    }

    protected void hidePopWindows() {
        if (this.streamListPopupWindow != null) {
            this.streamListPopupWindow.dismiss();
            this.streamListPopupWindow = null;
        }
    }

    protected void showPopupWindows() {
        if (this.streamListPopupWindow == null) {
            ArrayList<M3U8Stream> streamList = new ArrayList<M3U8Stream>();
            for (Map.Entry<String, M3U8Stream> entry : this.mM3U8StreamList.entrySet()) {
                if (this.mCurrentStreamName.equals(entry.getKey())) continue;
                streamList.add(entry.getValue());
            }
            this.streamListPopupWindow = this.initPopupWindows(streamList, this.mStreamListView.getWidth(), this.mStreamListView.getHeight());
        }
        this.streamListPopupWindow.showAsDropDown((View)this.mStreamListView, 0, 0);
    }

    protected PopupWindow initPopupWindows(final List<M3U8Stream> streamInfoLists, int width, int height) {
        RecyclerView listView = new RecyclerView(this.getContext());
        listView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        listView.addItemDecoration((RecyclerView.ItemDecoration)new ListDecoration(this.getContext(), 1, R.drawable.stream_list_decoration));
        StreamListAdapter adapter = new StreamListAdapter(this.getContext(), streamInfoLists);
        adapter.setOnItemClickListener(new OnItemClickListener(){

            @Override
            public void onItemClick(int position) {
                M3U8Stream m3U8Stream = (M3U8Stream)streamInfoLists.get(position);
                VideoControllerView.this.mCurrentStreamName = m3U8Stream.getKey();
                VideoControllerView.this.updateStreamListView(VideoControllerView.this.mCurrentStreamName);
                for (ControllerListener listener : VideoControllerView.this.mControllerListenerList) {
                    listener.onChangePlaySource(m3U8Stream.getUrl());
                }
                VideoControllerView.this.hidePopWindows();
            }
        });
        listView.setAdapter((RecyclerView.Adapter)adapter);
        PopupWindow popupWindow = new PopupWindow(this.getContext());
        popupWindow.setWidth(width);
        int decoration = this.getContext().getResources().getDimensionPixelOffset(R.dimen.stream_list_decoration);
        popupWindow.setHeight((height + decoration) * streamInfoLists.size());
        popupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        popupWindow.setOutsideTouchable(true);
        popupWindow.setFocusable(true);
        popupWindow.setContentView((View)listView);
        return popupWindow;
    }

    public void setDefaultRateArray(float[] defaultRateArray) {
        this.defaultRateArray = defaultRateArray;
    }

    protected View.OnClickListener getRateClickListener() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                VideoControllerView.this.mCurrentRateIndex = VideoControllerView.this.mCurrentRateIndex + 1;
                if (VideoControllerView.this.mCurrentRateIndex >= VideoControllerView.this.defaultRateArray.length) {
                    VideoControllerView.this.mCurrentRateIndex = 0;
                }
                VideoControllerView.this.updateRateView(VideoControllerView.this.defaultRateArray[VideoControllerView.this.mCurrentRateIndex]);
                for (ControllerListener listener : VideoControllerView.this.mControllerListenerList) {
                    listener.onChangeRate(VideoControllerView.this.defaultRateArray[VideoControllerView.this.mCurrentRateIndex]);
                }
            }
        };
    }

    protected View.OnClickListener getStreamListClickListener() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                if (VideoControllerView.this.isCached) {
                    return;
                }
                for (ControllerListener listener : VideoControllerView.this.mControllerListenerList) {
                    VideoControllerView.this.showPopupWindows();
                }
            }
        };
    }

    protected View.OnClickListener getPlayClickListener() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                VideoControllerView.this.mPlayBtn.setSelected(!VideoControllerView.this.mPlayBtn.isSelected());
                for (ControllerListener listener : VideoControllerView.this.mControllerListenerList) {
                    listener.onPlayStatusChange(VideoControllerView.this.mPlayBtn.isSelected());
                }
            }
        };
    }

    protected CompoundButton.OnCheckedChangeListener getOnScreenChangeListener() {
        return new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                for (ControllerListener listener : VideoControllerView.this.mControllerListenerList) {
                    listener.onChangeScreen(isChecked ? 2 : 1);
                }
            }
        };
    }

    protected SeekBar.OnSeekBarChangeListener getOnProgressChangeListener() {
        return new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                VideoControllerView.this.isSeekByUser = fromUser;
                if (!VideoControllerView.this.isSeekByUser) {
                    VideoControllerView.this.setNaturalMediaPosition(progress);
                }
                VideoControllerView.this.updateTime(progress, seekBar.getMax());
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                VideoControllerView.this.isSeekByUser = true;
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                VideoControllerView.this.isSeekByUser = false;
                if (VideoControllerView.this.getSeekToDropForwardEnable()) {
                    seekBar.setProgress(seekBar.getProgress());
                    if (seekBar.getProgress() > VideoControllerView.this.mNaturalSeekProgress) {
                        for (ControllerListener listener : VideoControllerView.this.mControllerListenerList) {
                            listener.onSeekToDropForward(VideoControllerView.this.mNaturalSeekProgress);
                        }
                        return;
                    }
                    for (ControllerListener listener : VideoControllerView.this.mControllerListenerList) {
                        listener.onSeek(seekBar.getProgress());
                    }
                    return;
                }
                for (ControllerListener listener : VideoControllerView.this.mControllerListenerList) {
                    listener.onSeek(seekBar.getProgress());
                }
            }
        };
    }

    public void updateControllerConfiguration(int orientation) {
        this.mOrientation = orientation;
        this.mScreenChangeView.setChecked(orientation == 2);
        if (orientation == 1) {
            ((View)this.mRateView.getParent()).setVisibility(8);
            ((View)this.mStreamListView.getParent()).setVisibility(8);
            this.mScreenChangeView.setVisibility(this.mControllerOptions.getOption("screen") ? 0 : 8);
            return;
        }
        ((View)this.mRateView.getParent()).setVisibility(this.mControllerOptions.getOption("rate") ? 0 : 8);
        if (this.isCached) {
            ((View)this.mStreamListView.getParent()).setVisibility(0);
            this.mStreamListView.setText((CharSequence)"\u5df2\u7f13\u5b58");
        } else {
            ((View)this.mStreamListView.getParent()).setVisibility(this.mM3U8StreamList != null && !this.mM3U8StreamList.isEmpty() ? 0 : 8);
        }
    }

    public void setScreenChangeVisible(int visible) {
        this.mScreenChangeView.setVisibility(visible);
    }

    public void setCached(boolean cached) {
        this.isCached = cached;
    }

    public boolean onTouchEvent(MotionEvent event) {
        Log.d((String)"videotest:", (String)("onTouchEvent:" + event.getAction()));
        if (this.mGestureDetector != null && this.mGestureDetector.onTouchEvent(event)) {
            return true;
        }
        if (this.mControllerViewTouchHelper == null) {
            this.onTouchEventBySelf(event);
            return true;
        }
        this.mControllerViewTouchHelper.updateTimeLength(this.mProgressView.getProgress(), this.mProgressView.getMax());
        if (this.mControllerViewTouchHelper.onTouchEvent(event)) {
            return true;
        }
        this.onTouchEventBySelf(event);
        return true;
    }

    private void onTouchEventBySelf(MotionEvent event) {
        if (event.getAction() == 1) {
            if (this.mToolsView.getVisibility() == 0) {
                this.hideOverlay();
            } else {
                this.showOverlay(5000);
            }
        }
    }

    public void onSeek(int position) {
        if (this.getSeekToDropForwardEnable()) {
            if (position > this.mNaturalSeekProgress) {
                for (ControllerListener listener : this.mControllerListenerList) {
                    listener.onSeekToDropForward(this.mNaturalSeekProgress);
                }
                return;
            }
            for (ControllerListener listener : this.mControllerListenerList) {
                listener.onSeek(position);
            }
            return;
        }
        if (!this.mProgressViewSeekEnable) {
            return;
        }
        for (ControllerListener listener : this.mControllerListenerList) {
            listener.onSeek(position);
        }
    }

    private boolean getSeekToDropForwardEnable() {
        return this.mSeekToDropForwardEnable;
    }

    public void setSeekToDropForwardEnable(boolean seekToDropForwardEnable) {
        this.mSeekToDropForwardEnable = seekToDropForwardEnable;
    }

    public void updatePlayStatus(boolean isPlay) {
        this.mPlayBtn.setSelected(isPlay);
    }

    public void updateMediaBufferState(float process) {
        this.mSecProcess = (int)(process / 100.0f) * 10000 / 1000;
        this.mProgressView.setSecondaryProgress(this.mProgressView.getProgress() + this.mSecProcess);
    }

    public void updateMediaProgress(int position, int duration) {
        if (this.isSeekByUser) {
            return;
        }
        this.mProgressView.setMax(duration);
        this.mProgressView.setProgress(position);
        this.mProgressView.setSecondaryProgress(position + this.mSecProcess);
        this.updateTime(position, duration);
        for (ControllerListener listener : this.mControllerListenerList) {
            listener.mediaProgressChanging(position);
        }
    }

    private void updateTime(int position, int duration) {
        String result = String.format("%s/%s", Strings.millisToString(position), Strings.millisToString(duration));
        this.mTimeView.setText((CharSequence)result);
    }

    public int getNaturalSeekProgress() {
        return this.mNaturalSeekProgress;
    }

    public void setSeekEnable(boolean enable) {
        this.mProgressViewSeekEnable = enable;
        this.mProgressView.setEnabled(this.mProgressViewSeekEnable);
    }

    public void setNaturalMediaPosition(long naturalMediaPosition) {
        if (Integer.parseInt(String.valueOf(naturalMediaPosition)) > this.mNaturalSeekProgress) {
            this.mNaturalSeekProgress = Integer.parseInt(String.valueOf(naturalMediaPosition));
        }
    }

    public static interface ControllerListener {
        public void onSeek(int var1);

        public void onChangeScreen(int var1);

        public void onPlayStatusChange(boolean var1);

        public void onChangeRate(float var1);

        public void onChangePlaySource(String var1);

        public void onChangeOverlay(boolean var1);

        default public void onSeekToDropForward(int position) {
        }

        default public void mediaProgressChanging(int position) {
            Log.i((String)"MediaPosition", (String)("" + position));
        }
    }
}

