/*
 * Decompiled with CFR 0.152.
 */
package com.edusoho.videoplayer.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.edusoho.videoplayer.R;

public class VideoPlayerHeaderView
extends FrameLayout {
    private HeaderEventListener mHeaderEventListener;
    private TextView mNavigationView;
    private ViewGroup mMenuViewGroup;

    public VideoPlayerHeaderView(Context context) {
        super(context, null);
        this.initView();
    }

    public VideoPlayerHeaderView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs, 0);
        this.initView();
    }

    @TargetApi(value=21)
    public VideoPlayerHeaderView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr, 0);
        this.initView();
    }

    protected void initView() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.view_controller_header_layout, (ViewGroup)this, true);
        this.mNavigationView = (TextView)this.findViewById(R.id.tv_header_navigation);
        this.mMenuViewGroup = (ViewGroup)this.findViewById(R.id.fl_header_menu);
        this.bindClickListener();
    }

    public void setHeaderEventListener(HeaderEventListener headerEventListener) {
        this.mHeaderEventListener = headerEventListener;
    }

    private void bindClickListener() {
        this.mNavigationView.setOnClickListener(this.getNavigationViewClickListener());
    }

    protected View.OnClickListener getNavigationViewClickListener() {
        return new View.OnClickListener(){

            public void onClick(View v) {
                if (VideoPlayerHeaderView.this.mHeaderEventListener != null) {
                    VideoPlayerHeaderView.this.mHeaderEventListener.onBack();
                }
            }
        };
    }

    public void setTitle(String title) {
        this.mNavigationView.setText((CharSequence)title);
    }

    public void setNavigationIcon(int icon) {
        this.mNavigationView.setCompoundDrawablesWithIntrinsicBounds(icon, 0, 0, 0);
    }

    public void setMenuLayout(View menuView) {
        this.mMenuViewGroup.removeAllViews();
        this.mMenuViewGroup.addView(menuView);
    }

    public static interface HeaderEventListener {
        public void onBack();
    }
}

